/*
 * Decompiled with CFR 0.152.
 */
package com.wooga.spock.extensions.github;

import com.wooga.spock.extensions.github.GithubRepositoryExtension;
import com.wooga.spock.extensions.github.api.EmptyRepositoryPostFix;
import com.wooga.spock.extensions.github.api.RateLimitHandlerFail;
import com.wooga.spock.extensions.github.api.RepositoryPostFix;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.kohsuke.github.RateLimitHandler;
import org.spockframework.runtime.extension.ExtensionAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
@ExtensionAnnotation(value=GithubRepositoryExtension.class)
public @interface GithubRepository {
    public String usernameEnv() default "GITHUB_USERNAME";

    public String tokenEnv() default "GITHUB_TOKEN";

    public String repositoryNamePrefix() default "test-repo";

    public Class<RepositoryPostFix>[] repositoryPostFixProvider() default {EmptyRepositoryPostFix.class};

    public String repositoryDescription() default "Integration test repo";

    public String endpoint() default "https://api.github.com";

    public Class<RateLimitHandler> rateLimitHandler() default RateLimitHandlerFail.class;

    public boolean resetAfterTestCase() default false;

    public boolean createPrivateRepository() default false;

    public boolean setupIssues() default false;

    public boolean setupWiki() default false;

    public boolean enableDownloads() default false;

    public boolean allowRebaseMerge() default true;

    public boolean allowMergeCommit() default true;

    public boolean allowSquashMerge() default true;

    public boolean autoInit() default true;

    public String gitignoreTemplate() default "";

    public String licenseTemplate() default "MIT";
}

