/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.glance.v2;

import com.woorea.openstack.base.client.Entity;
import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.base.client.OpenStackResponse;
import com.woorea.openstack.glance.model.v2.Image;
import com.woorea.openstack.glance.model.v2.ImageDownload;
import com.woorea.openstack.glance.model.v2.Images;

public class ImagesResource {
    private final OpenStackClient CLIENT;

    public ImagesResource(OpenStackClient client) {
        this.CLIENT = client;
    }

    public List list(boolean detail) {
        return new List(detail);
    }

    public Create create(Image image) {
        return new Create(image);
    }

    public Show show(String id) {
        return new Show(id);
    }

    public Delete delete(String id) {
        return new Delete(id);
    }

    public Download download(String id) {
        return new Download(id);
    }

    public class Download
    extends OpenStackRequest<ImageDownload> {
        public Download(String id) {
            super(ImagesResource.this.CLIENT, HttpMethod.GET, "/images/" + id + "/file", null, ImageDownload.class);
            this.header("Accept", "application/octet-stream");
        }

        public ImageDownload execute() {
            OpenStackResponse response = ImagesResource.this.CLIENT.request((OpenStackRequest)this);
            ImageDownload imageDownload = new ImageDownload();
            imageDownload.setInputStream(response.getInputStream());
            return imageDownload;
        }
    }

    public class Show
    extends OpenStackRequest<Image> {
        public Show(String id) {
            super(ImagesResource.this.CLIENT, HttpMethod.GET, "/images/" + id, null, Image.class);
        }
    }

    public class Delete
    extends OpenStackRequest<Void> {
        public Delete(String id) {
            super(ImagesResource.this.CLIENT, HttpMethod.DELETE, "/images/" + id, null, Void.class);
        }
    }

    public class Create
    extends OpenStackRequest<Image> {
        public Create(Image image) {
            super(ImagesResource.this.CLIENT, HttpMethod.POST, "/images", Entity.json((Object)image), Image.class);
        }
    }

    public class List
    extends OpenStackRequest<Images> {
        public List(boolean detail) {
            super(ImagesResource.this.CLIENT, HttpMethod.GET, "/images", null, Images.class);
        }
    }
}

