/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.keystone.api;

import com.woorea.openstack.base.client.Entity;
import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.keystone.model.Roles;
import com.woorea.openstack.keystone.model.Tenant;
import com.woorea.openstack.keystone.model.Tenants;
import com.woorea.openstack.keystone.model.Users;

public class TenantsResource {
    private OpenStackClient client;

    public TenantsResource(OpenStackClient client) {
        this.client = client;
    }

    public List list() {
        return new List();
    }

    public Create create(Tenant tenant) {
        return new Create(tenant);
    }

    public Show show(String id) {
        return new Show(id);
    }

    public Update update(String id, Tenant tenant) {
        return new Update(id, tenant);
    }

    public Delete delete(String id) {
        return new Delete(id);
    }

    public ListUsers listUsers(String tenantId) {
        return new ListUsers(tenantId);
    }

    public AddUser addUser(String tenantId, String userId, String roleId) {
        return new AddUser(tenantId, userId, roleId);
    }

    public RemoveUser removeUser(String tenantId, String userId, String roleId) {
        return new RemoveUser(tenantId, userId, roleId);
    }

    public ListUserRoles listUserRoles(String tenantId, String userId) {
        return new ListUserRoles(tenantId, userId);
    }

    public class ListUserRoles
    extends OpenStackRequest<Roles> {
        public ListUserRoles(String tenantId, String userId) {
            super(TenantsResource.this.client, HttpMethod.GET, "/tenants/" + tenantId + "/users/" + userId + "/roles", null, Roles.class);
        }
    }

    public class RemoveUser
    extends OpenStackRequest<Void> {
        public RemoveUser(String tenantId, String userId, String roleId) {
            super(TenantsResource.this.client, HttpMethod.DELETE, "/tenants/" + tenantId + "/users/" + userId + "/roles/OS-KSADM/" + roleId, null, Void.class);
        }
    }

    public class AddUser
    extends OpenStackRequest<Void> {
        public AddUser(String tenantId, String userId, String roleId) {
            super(TenantsResource.this.client, HttpMethod.PUT, "/tenants/" + tenantId + "/users/" + userId + "/roles/OS-KSADM/" + roleId, null, Void.class);
        }
    }

    public class ListUsers
    extends OpenStackRequest<Users> {
        public ListUsers(String tenantId) {
            super(TenantsResource.this.client, HttpMethod.GET, "/tenants/" + tenantId + "/users", null, Users.class);
        }
    }

    public class Delete
    extends OpenStackRequest<Void> {
        public Delete(String id) {
            super(TenantsResource.this.client, HttpMethod.DELETE, "/tenants/" + id, null, Void.class);
        }
    }

    public class Update
    extends OpenStackRequest<Tenant> {
        private Tenant tenant;

        public Update(String id, Tenant tenant) {
            super(TenantsResource.this.client, HttpMethod.PUT, "/tenants/" + id, Entity.json((Object)tenant), Tenant.class);
            this.tenant = tenant;
        }
    }

    public class Show
    extends OpenStackRequest<Tenant> {
        public Show(String id) {
            super(TenantsResource.this.client, HttpMethod.GET, "/tenants/" + id, null, Tenant.class);
        }
    }

    public class Create
    extends OpenStackRequest<Tenant> {
        private Tenant tenant;

        public Create(Tenant tenant) {
            super(TenantsResource.this.client, HttpMethod.POST, "/tenants", Entity.json((Object)tenant), Tenant.class);
            this.tenant = tenant;
        }
    }

    public class List
    extends OpenStackRequest<Tenants> {
        public List() {
            super(TenantsResource.this.client, HttpMethod.GET, "/tenants", null, Tenants.class);
        }
    }
}

