/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.keystone.api;

import com.woorea.openstack.base.client.Entity;
import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.keystone.model.Access;
import com.woorea.openstack.keystone.model.Authentication;
import com.woorea.openstack.keystone.model.authentication.AccessKey;
import com.woorea.openstack.keystone.model.authentication.TokenAuthentication;
import com.woorea.openstack.keystone.model.authentication.UsernamePassword;

public class TokensResource {
    private final OpenStackClient CLIENT;

    public TokensResource(OpenStackClient client) {
        this.CLIENT = client;
    }

    public Authenticate.Builder authenticate() {
        return new Authenticate().new Authenticate.Builder();
    }

    public Authenticate authenticate(Authentication authentication) {
        return new Authenticate(authentication);
    }

    public class Authenticate
    extends OpenStackRequest<Access> {
        private Authentication authentication;

        public Authenticate() {
        }

        public Authenticate(Authentication authentication) {
            super(TokensResource.this.CLIENT, HttpMethod.POST, "/tokens", Entity.json((Object)authentication), Access.class);
            this.authentication = authentication;
        }

        public Authenticate withTenantId(String tenantId) {
            this.authentication.setTenantId(tenantId);
            return this;
        }

        public Authenticate withTenantName(String tenantName) {
            this.authentication.setTenantName(tenantName);
            return this;
        }

        public class Builder {
            public Authenticate withUsernamePassword(String username, String password) {
                UsernamePassword authentication = new UsernamePassword(username, password);
                return new Authenticate((Authentication)authentication);
            }

            public Authenticate withToken(String token) {
                TokenAuthentication authentication = new TokenAuthentication(token);
                return new Authenticate((Authentication)authentication);
            }

            public Authenticate withAccessKey(String accessKey, String secretKey) {
                AccessKey authentication = new AccessKey(accessKey, secretKey);
                return new Authenticate((Authentication)authentication);
            }
        }
    }
}

