/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.keystone.utils;

import com.woorea.openstack.base.client.OpenStackTokenProvider;
import com.woorea.openstack.keystone.Keystone;
import com.woorea.openstack.keystone.model.Access;
import com.woorea.openstack.keystone.model.Authentication;
import com.woorea.openstack.keystone.model.authentication.UsernamePassword;
import java.util.concurrent.ConcurrentHashMap;

public class KeystoneTokenProvider {
    protected Keystone keystone;
    protected String username;
    protected String password;
    ConcurrentHashMap<String, Access> hashTenantAccess;

    public KeystoneTokenProvider(String endpoint, String username, String password) {
        this.keystone = new Keystone(endpoint);
        this.username = username;
        this.password = password;
        this.hashTenantAccess = new ConcurrentHashMap();
    }

    public Access getAccessByTenant(String tenantName) {
        Access access = this.hashTenantAccess.get(tenantName);
        if (access == null) {
            access = (Access)this.keystone.tokens().authenticate((Authentication)new UsernamePassword(this.username, this.password)).withTenantName(tenantName).execute();
            this.hashTenantAccess.put(tenantName, access);
        }
        return access;
    }

    public void expireAccessByTenant(String tenantName) {
        this.hashTenantAccess.remove(tenantName);
    }

    public OpenStackTokenProvider getProviderByTenant(final String tenantName) {
        final KeystoneTokenProvider keystoneTokenProvider = this;
        return new OpenStackTokenProvider(){

            public String getToken() {
                return keystoneTokenProvider.getAccessByTenant(tenantName).getToken().getId();
            }

            public void expireToken() {
                keystoneTokenProvider.expireAccessByTenant(tenantName);
            }
        };
    }
}

