/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.keystone.utils;

import com.woorea.openstack.keystone.model.Access;
import java.util.List;

public class KeystoneUtils {
    public static String findEndpointURL(List<Access.Service> serviceCatalog, String type, String region, String facing) {
        for (Access.Service service : serviceCatalog) {
            if (!type.equals(service.getType())) continue;
            for (Access.Service.Endpoint endpoint : service.getEndpoints()) {
                if (region != null && !region.equals(endpoint.getRegion())) continue;
                if (endpoint.getPublicURL() != null && facing.equals("public")) {
                    return endpoint.getPublicURL();
                }
                if (endpoint.getInternalURL() != null && facing.equals("internal")) {
                    return endpoint.getInternalURL();
                }
                if (endpoint.getAdminURL() == null || !facing.equals("admin")) continue;
                return endpoint.getAdminURL();
            }
        }
        throw new RuntimeException("endpoint url not found");
    }
}

