/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.keystone.v3.model;

import com.fasterxml.jackson.annotation.JsonRootName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonRootName(value="auth")
public class Authentication
implements Serializable {
    private Identity identity;
    private Scope scope;

    public Identity getIdentity() {
        return this.identity;
    }

    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public static final class Scope {
        private Project project;

        public static Scope project(String id) {
            Scope scope = new Scope();
            Project project = new Project();
            project.setId(id);
            scope.setProject(project);
            return scope;
        }

        public static Scope project(String domainName, String projectName) {
            Scope scope = new Scope();
            Project.Domain domain = new Project.Domain();
            domain.setName(domainName);
            Project project = new Project();
            project.setDomain(domain);
            project.setName(projectName);
            scope.setProject(project);
            return scope;
        }

        public Project getProject() {
            return this.project;
        }

        public void setProject(Project project) {
            this.project = project;
        }

        public static final class Project {
            private String id;
            private Domain domain;
            private String name;

            public String getId() {
                return this.id;
            }

            public void setId(String id) {
                this.id = id;
            }

            public Domain getDomain() {
                return this.domain;
            }

            public void setDomain(Domain domain) {
                this.domain = domain;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public static final class Domain {
                private String id;
                private String name;

                public String getId() {
                    return this.id;
                }

                public void setId(String id) {
                    this.id = id;
                }

                public String getName() {
                    return this.name;
                }

                public void setName(String name) {
                    this.name = name;
                }
            }
        }
    }

    public static final class Identity {
        private List<String> methods = new ArrayList<String>();
        private Password password;
        private Token token;

        public static final Identity password(String userId, String password) {
            Identity identity = new Identity();
            identity.getMethods().add("password");
            Password method = new Password();
            method.getUser().setId(userId);
            method.getUser().setPassword(password);
            identity.setPassword(method);
            return identity;
        }

        public static final Identity password(String domainName, String username, String password) {
            Identity identity = new Identity();
            identity.getMethods().add("password");
            Password method = new Password();
            Password.User.Domain domain = new Password.User.Domain();
            domain.setName(domainName);
            method.getUser().setDomain(domain);
            method.getUser().setName(username);
            method.getUser().setPassword(password);
            identity.setPassword(method);
            return identity;
        }

        public static final Identity token(String token) {
            Identity identity = new Identity();
            identity.getMethods().add("token");
            Token method = new Token();
            method.setId(token);
            identity.setToken(method);
            return identity;
        }

        public List<String> getMethods() {
            return this.methods;
        }

        public void setMethods(List<String> methods) {
            this.methods = methods;
        }

        public Password getPassword() {
            return this.password;
        }

        public void setPassword(Password password) {
            this.password = password;
        }

        public Token getToken() {
            return this.token;
        }

        public void setToken(Token token) {
            this.token = token;
        }

        public static final class Token {
            private String id;

            public String getId() {
                return this.id;
            }

            public void setId(String id) {
                this.id = id;
            }
        }

        public static final class Password {
            private User user = new User();

            public User getUser() {
                return this.user;
            }

            public void setUser(User user) {
                this.user = user;
            }

            public static final class User {
                private Domain domain;
                private String id;
                private String name;
                private String password;

                public Domain getDomain() {
                    return this.domain;
                }

                public void setDomain(Domain domain) {
                    this.domain = domain;
                }

                public String getId() {
                    return this.id;
                }

                public void setId(String id) {
                    this.id = id;
                }

                public String getName() {
                    return this.name;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public String getPassword() {
                    return this.password;
                }

                public void setPassword(String password) {
                    this.password = password;
                }

                public static final class Domain {
                    private String id;
                    private String name;

                    public String getId() {
                        return this.id;
                    }

                    public void setId(String id) {
                        this.id = id;
                    }

                    public String getName() {
                        return this.name;
                    }

                    public void setName(String name) {
                        this.name = name;
                    }
                }
            }
        }
    }
}

