/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.base.client;

import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClientConnector;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.base.client.OpenStackResponse;
import com.woorea.openstack.base.client.OpenStackResponseException;
import com.woorea.openstack.base.client.OpenStackSimpleTokenProvider;
import com.woorea.openstack.base.client.OpenStackTokenProvider;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;

public class OpenStackClient {
    protected String endpoint;
    protected OpenStackTokenProvider tokenProvider;
    protected static int AUTHENTICATION_RETRIES;
    protected OpenStackClientConnector connector;
    protected Properties properties = new Properties();
    protected static OpenStackClientConnector DEFAULT_CONNECTOR;

    public OpenStackClient(String endpoint) {
        this.endpoint = endpoint;
        this.connector = DEFAULT_CONNECTOR;
    }

    public OpenStackClient(String endpoint, OpenStackClientConnector connector) {
        this.endpoint = endpoint;
        this.connector = connector == null ? DEFAULT_CONNECTOR : connector;
    }

    public <T> OpenStackResponse request(OpenStackRequest<T> request) {
        OpenStackResponseException authException = null;
        for (int i = 0; i <= AUTHENTICATION_RETRIES; ++i) {
            request.endpoint(this.endpoint);
            if (this.tokenProvider != null) {
                request.header("X-Auth-Token", this.tokenProvider.getToken());
            }
            try {
                return this.connector.request(request);
            }
            catch (OpenStackResponseException e) {
                if (e.getStatus() != 401 || this.tokenProvider == null) {
                    throw e;
                }
                authException = e;
                this.tokenProvider.expireToken();
                continue;
            }
        }
        throw authException;
    }

    public <T> T execute(OpenStackRequest<T> request) {
        OpenStackResponse response = this.request(request);
        return request.returnType() != null && request.returnType() != Void.class ? (T)response.getEntity(request.returnType()) : null;
    }

    public void property(String property, String value) {
        this.properties.put(property, value);
    }

    public void setTokenProvider(OpenStackTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public void token(String token) {
        this.setTokenProvider(new OpenStackSimpleTokenProvider(token));
    }

    public <R> OpenStackRequest<R> get(String path, Class<R> returnType) {
        return new OpenStackRequest<R>(this, HttpMethod.GET, path, null, returnType);
    }

    static {
        block0: {
            OpenStackClientConnector clientConnector;
            AUTHENTICATION_RETRIES = 1;
            ServiceLoader<OpenStackClientConnector> connectorLoader = ServiceLoader.load(OpenStackClientConnector.class);
            Iterator<OpenStackClientConnector> iterator = connectorLoader.iterator();
            if (!iterator.hasNext()) break block0;
            DEFAULT_CONNECTOR = clientConnector = iterator.next();
        }
    }
}

