/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.quantum.api;

import com.woorea.openstack.base.client.Entity;
import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.quantum.model.Network;
import com.woorea.openstack.quantum.model.Networks;

public class NetworksResource {
    private final OpenStackClient CLIENT;

    public NetworksResource(OpenStackClient client) {
        this.CLIENT = client;
    }

    public List list() {
        return new List();
    }

    public Create create(Network net) {
        return new Create(net);
    }

    public Update update(Network net) {
        return new Update(net);
    }

    public Delete delete(String netId) {
        return new Delete(netId);
    }

    public Show show(String netId) {
        return new Show(netId);
    }

    public class Delete
    extends OpenStackRequest<Void> {
        public Delete(String id) {
            super(NetworksResource.this.CLIENT, HttpMethod.DELETE, Delete.buildPath((String[])new String[]{"networks", id}), null, Void.class);
        }
    }

    public class Show
    extends OpenStackRequest<Network> {
        public Show(String id) {
            super(NetworksResource.this.CLIENT, HttpMethod.GET, Show.buildPath((String[])new String[]{"networks", id}), null, Network.class);
        }
    }

    public class Update
    extends OpenStackRequest<Network> {
        public Update(Network net) {
            super(NetworksResource.this.CLIENT, HttpMethod.PUT, Update.buildPath((String[])new String[]{"networks", net.getId()}), Entity.json((Object)net), Network.class);
        }
    }

    public class Create
    extends OpenStackRequest<Network> {
        public Create(Network net) {
            super(NetworksResource.this.CLIENT, HttpMethod.POST, Create.buildPath((String[])new String[]{"networks"}), Entity.json((Object)net), Network.class);
        }
    }

    public class Query
    extends OpenStackRequest<Networks> {
        public Query(Network network) {
        }
    }

    public class List
    extends OpenStackRequest<Networks> {
        public List() {
            super(NetworksResource.this.CLIENT, HttpMethod.GET, List.buildPath((String[])new String[]{"networks"}), null, Networks.class);
        }
    }
}

