/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.quantum.api;

import com.woorea.openstack.base.client.Entity;
import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.quantum.model.Router;
import com.woorea.openstack.quantum.model.RouterForAddInterface;
import com.woorea.openstack.quantum.model.RouterForCreate;
import com.woorea.openstack.quantum.model.RouterInterface;
import com.woorea.openstack.quantum.model.Routers;

public class RoutersResource {
    private final OpenStackClient CLIENT;

    public RoutersResource(OpenStackClient client) {
        this.CLIENT = client;
    }

    public List list() {
        return new List();
    }

    public Create create(RouterForCreate router) {
        return new Create(router);
    }

    public Delete delete(String netId) {
        return new Delete(netId);
    }

    public Show show(String netId) {
        return new Show(netId);
    }

    public Attach addInterface(RouterForAddInterface interfaceToAdd) {
        return new Attach(interfaceToAdd);
    }

    public Detach deleteInterface(RouterForAddInterface interfaceRouter) {
        return new Detach(interfaceRouter);
    }

    public class Detach
    extends OpenStackRequest<RouterInterface> {
        public Detach(RouterForAddInterface interfaceToAdd) {
            super(RoutersResource.this.CLIENT, HttpMethod.PUT, Detach.buildPath((String[])new String[]{"routers", interfaceToAdd.getRouterId(), "remove_router_interface"}), Entity.json((Object)interfaceToAdd), RouterInterface.class);
        }
    }

    public class Attach
    extends OpenStackRequest<RouterInterface> {
        public Attach(RouterForAddInterface interfaceToAdd) {
            super(RoutersResource.this.CLIENT, HttpMethod.PUT, Attach.buildPath((String[])new String[]{"routers", interfaceToAdd.getRouterId(), "add_router_interface"}), Entity.json((Object)interfaceToAdd), RouterInterface.class);
        }
    }

    public class Delete
    extends OpenStackRequest<Void> {
        public Delete(String id) {
            super(RoutersResource.this.CLIENT, HttpMethod.DELETE, Delete.buildPath((String[])new String[]{"routers", id}), null, Void.class);
        }
    }

    public class Show
    extends OpenStackRequest<Router> {
        public Show(String id) {
            super(RoutersResource.this.CLIENT, HttpMethod.GET, Show.buildPath((String[])new String[]{"routers", id}), null, Router.class);
        }
    }

    public class Create
    extends OpenStackRequest<Router> {
        public Create(RouterForCreate router) {
            super(RoutersResource.this.CLIENT, HttpMethod.POST, Create.buildPath((String[])new String[]{"routers"}), Entity.json((Object)router), Router.class);
        }
    }

    public class Query
    extends OpenStackRequest<Routers> {
        public Query(Router router) {
        }
    }

    public class List
    extends OpenStackRequest<Routers> {
        public List() {
            super(RoutersResource.this.CLIENT, HttpMethod.GET, List.buildPath((String[])new String[]{"routers"}), null, Routers.class);
        }
    }
}

