/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.connector;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.woorea.openstack.base.client.OpenStackClientConnector;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.base.client.OpenStackResponse;
import com.woorea.openstack.base.client.OpenStackResponseException;
import com.woorea.openstack.connector.RESTEasyResponse;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.InputStreamProvider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class RESTEasyConnector
implements OpenStackClientConnector {
    public static ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    public static ObjectMapper WRAPPED_MAPPER;
    private static ResteasyProviderFactory providerFactory;

    protected ClientExecutor createClientExecutor() {
        return ClientRequest.getDefaultExecutor();
    }

    public <T> OpenStackResponse request(OpenStackRequest<T> request) {
        ClientResponse response;
        String requestPath = request.path();
        if (requestPath != null && requestPath.isEmpty()) {
            requestPath = "/";
        }
        ClientRequest client = new ClientRequest(UriBuilder.fromUri((String)(request.endpoint() + requestPath)), this.createClientExecutor(), providerFactory);
        for (Map.Entry entry : request.queryParams().entrySet()) {
            for (Object o : (List)entry.getValue()) {
                client = client.queryParameter((String)entry.getKey(), (Object)String.valueOf(o));
            }
        }
        for (Map.Entry h : request.headers().entrySet()) {
            StringBuilder sb = new StringBuilder();
            for (Object v : (List)h.getValue()) {
                sb.append(String.valueOf(v));
            }
            client.header((String)h.getKey(), (Object)sb);
        }
        if (request.entity() != null) {
            client.body(request.entity().getContentType(), request.entity().getEntity());
        }
        try {
            response = client.httpMethod(request.method().name(), request.returnType());
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected client exception", e);
        }
        if (response.getStatus() == 200 || response.getStatus() == 201 || response.getStatus() == 204 || response.getStatus() == 202) {
            return new RESTEasyResponse(client, response);
        }
        response.releaseConnection();
        throw new OpenStackResponseException(response.getResponseStatus().getReasonPhrase(), response.getStatus());
    }

    static {
        DEFAULT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        DEFAULT_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        DEFAULT_MAPPER.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        DEFAULT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        DEFAULT_MAPPER.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        WRAPPED_MAPPER = new ObjectMapper();
        WRAPPED_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        WRAPPED_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        WRAPPED_MAPPER.enable(SerializationFeature.WRAP_ROOT_VALUE);
        WRAPPED_MAPPER.enable(DeserializationFeature.UNWRAP_ROOT_VALUE);
        WRAPPED_MAPPER.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        WRAPPED_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        WRAPPED_MAPPER.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        providerFactory = new ResteasyProviderFactory();
        providerFactory.registerProviderInstance((Object)new JacksonJsonProvider());
        providerFactory.registerProviderInstance((Object)new ObjectMapperContextResolver());
        providerFactory.registerProviderInstance((Object)new InputStreamProvider());
    }

    @Provider
    @Produces(value={"application/json"})
    static class ObjectMapperContextResolver
    implements ContextResolver<ObjectMapper> {
        ObjectMapperContextResolver() {
        }

        public ObjectMapper getContext(Class<?> type) {
            return type.getAnnotation(JsonRootName.class) == null ? DEFAULT_MAPPER : WRAPPED_MAPPER;
        }
    }
}

