/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.jaxrs;

import com.wordnik.swagger.converter.ModelConverters;
import com.wordnik.swagger.jaxrs.ext.AbstractSwaggerExtension;
import com.wordnik.swagger.jaxrs.ext.SwaggerExtension;
import com.wordnik.swagger.models.parameters.CookieParameter;
import com.wordnik.swagger.models.parameters.FormParameter;
import com.wordnik.swagger.models.parameters.HeaderParameter;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.parameters.PathParameter;
import com.wordnik.swagger.models.parameters.QueryParameter;
import com.wordnik.swagger.models.properties.Property;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultParameterExtension
extends AbstractSwaggerExtension
implements SwaggerExtension {
    Logger LOGGER = LoggerFactory.getLogger(DefaultParameterExtension.class);

    @Override
    public List<Parameter> extractParameters(Annotation[] annotations, Class<?> cls, boolean isArray, Set<Class<?>> classesToSkip, Iterator<SwaggerExtension> chain) {
        String defaultValue = null;
        if (this.shouldIgnoreClass(cls)) {
            return new ArrayList<Parameter>();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        QueryParameter parameter = null;
        for (Annotation annotation : annotations) {
            Property schema;
            QueryParam param;
            if (annotation instanceof QueryParam) {
                param = (QueryParam)annotation;
                QueryParameter qp = new QueryParameter().name(param.value());
                qp.setDefaultValue(defaultValue);
                schema = ModelConverters.getInstance().readAsProperty(cls);
                if (schema != null) {
                    qp.setProperty(schema);
                }
                parameter = qp;
                continue;
            }
            if (annotation instanceof PathParam) {
                param = (PathParam)annotation;
                PathParameter pp = new PathParameter().name(param.value());
                pp.setDefaultValue(defaultValue);
                schema = ModelConverters.getInstance().readAsProperty(cls);
                if (schema != null) {
                    pp.setProperty(schema);
                }
                parameter = pp;
                continue;
            }
            if (annotation instanceof HeaderParam) {
                param = (HeaderParam)annotation;
                HeaderParameter hp = new HeaderParameter().name(param.value());
                hp.setDefaultValue(defaultValue);
                schema = ModelConverters.getInstance().readAsProperty(cls);
                if (schema != null) {
                    hp.setProperty(schema);
                }
                parameter = hp;
                continue;
            }
            if (annotation instanceof CookieParam) {
                param = (CookieParam)annotation;
                CookieParameter cp = new CookieParameter().name(param.value());
                cp.setDefaultValue(defaultValue);
                schema = ModelConverters.getInstance().readAsProperty(cls);
                if (schema != null) {
                    cp.setProperty(schema);
                }
                parameter = cp;
                continue;
            }
            if (annotation instanceof FormParam) {
                param = (FormParam)annotation;
                FormParameter fp = new FormParameter().name(param.value());
                fp.setDefaultValue(defaultValue);
                schema = ModelConverters.getInstance().readAsProperty(cls);
                if (schema != null) {
                    fp.setProperty(schema);
                }
                parameter = fp;
                continue;
            }
            if (!(annotation instanceof DefaultValue)) continue;
            DefaultValue defaultValueAnnotation = (DefaultValue)annotation;
            defaultValue = defaultValueAnnotation.value();
        }
        if (parameter != null) {
            parameters.add((Parameter)parameter);
        }
        return parameters;
    }

    @Override
    public boolean shouldIgnoreClass(Class<?> cls) {
        boolean output = false;
        output = cls.getName().startsWith("javax.ws.rs");
        return output;
    }
}

