/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.jaxrs.config;

import com.wordnik.swagger.config.FilterFactory;
import com.wordnik.swagger.config.ScannerFactory;
import com.wordnik.swagger.config.SwaggerConfig;
import com.wordnik.swagger.core.filter.SwaggerSpecFilter;
import com.wordnik.swagger.jaxrs.config.DefaultJaxrsScanner;
import com.wordnik.swagger.models.Info;
import com.wordnik.swagger.models.Scheme;
import com.wordnik.swagger.models.Swagger;
import javax.servlet.ServletConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXMLReader
implements SwaggerConfig {
    Logger LOGGER = LoggerFactory.getLogger(WebXMLReader.class);
    String basePath;
    String host;
    String filterClass;
    String apiVersion;
    String title;
    String scheme = "http";

    public WebXMLReader(ServletConfig servletConfig) {
        String[] parts;
        String shouldPrettyPrint;
        DefaultJaxrsScanner scanner = new DefaultJaxrsScanner();
        ScannerFactory.setScanner(scanner);
        this.apiVersion = servletConfig.getInitParameter("api.version");
        if (this.apiVersion == null) {
            this.apiVersion = "Swagger Server";
        }
        if ((shouldPrettyPrint = servletConfig.getInitParameter("swagger.pretty.print")) != null) {
            scanner.setPrettyPrint(Boolean.parseBoolean(shouldPrettyPrint));
        }
        this.basePath = servletConfig.getInitParameter("swagger.api.basepath");
        this.title = servletConfig.getInitParameter("swagger.api.title");
        if (this.title == null) {
            this.title = "";
        }
        if (this.basePath != null && (parts = this.basePath.split("://")).length > 1) {
            int pos = parts[1].indexOf("/");
            if (pos >= 0) {
                this.scheme = parts[0];
                this.basePath = parts[1].substring(pos);
                this.host = parts[1].substring(0, pos);
            } else {
                this.scheme = parts[0];
                this.basePath = null;
                this.host = parts[1];
            }
        }
        this.filterClass = servletConfig.getInitParameter("swagger.filter");
        if (this.filterClass != null) {
            try {
                SwaggerSpecFilter filter = (SwaggerSpecFilter)Class.forName(this.filterClass).newInstance();
                if (filter != null) {
                    FilterFactory.setFilter((SwaggerSpecFilter)filter);
                }
            }
            catch (Exception e) {
                this.LOGGER.error("failed to load filter", (Throwable)e);
            }
        }
    }

    public Swagger configure(Swagger swagger) {
        if (swagger != null) {
            Info info = swagger.getInfo();
            if (info == null) {
                swagger.info(new Info());
            }
            swagger.basePath(this.basePath).host(this.host).scheme(Scheme.forValue((String)this.scheme)).getInfo().title(this.title).version(this.apiVersion);
        }
        return swagger;
    }
}

