/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputText;
import com.worksap.nlp.sudachi.Lattice;
import com.worksap.nlp.sudachi.LatticeNode;
import com.worksap.nlp.sudachi.PathRewritePlugin;
import com.worksap.nlp.sudachi.dictionary.CategoryType;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import java.util.List;

class JoinKatakanaOovPlugin
extends PathRewritePlugin {
    short oovPosId;
    int minLength;

    JoinKatakanaOovPlugin() {
    }

    @Override
    public void setUp(Grammar grammar) {
        List<String> pos = this.settings.getStringList("oovPOS");
        if (pos.isEmpty()) {
            throw new IllegalArgumentException("oovPOS is undefined");
        }
        this.oovPosId = grammar.getPartOfSpeechId(pos);
        if (this.oovPosId < 0) {
            throw new IllegalArgumentException("oovPOS is invalid");
        }
        this.minLength = this.settings.getInt("minLength", 1);
        if (this.minLength < 0) {
            throw new IllegalArgumentException("minLength is negative");
        }
    }

    @Override
    public void rewrite(InputText text, List<LatticeNode> path, Lattice lattice) {
        for (int i = 0; i < path.size(); ++i) {
            int end;
            int begin;
            LatticeNode node = path.get(i);
            if (!node.isOOV() && !this.isShorter(this.minLength, text, node) || !this.isKatakanaNode(text, node)) continue;
            for (begin = i - 1; begin >= 0; --begin) {
                if (this.isKatakanaNode(text, path.get(begin))) continue;
                ++begin;
                break;
            }
            if (begin < 0) {
                begin = 0;
            }
            for (end = i + 1; end < path.size() && this.isKatakanaNode(text, path.get(end)); ++end) {
            }
            while (begin != end && !this.canOovBowNode(text, path.get(begin))) {
                ++begin;
            }
            if (end - begin <= 1) continue;
            this.concatenateOov(path, begin, end, this.oovPosId, lattice);
            i = begin + 1;
        }
    }

    boolean isKatakanaNode(InputText text, LatticeNode node) {
        return this.getCharCategoryTypes(text, node).contains((Object)CategoryType.KATAKANA);
    }

    boolean isShorter(int length, InputText text, LatticeNode node) {
        return text.codePointCount(node.getBegin(), node.getEnd()) < length;
    }

    boolean canOovBowNode(InputText text, LatticeNode node) {
        return !text.getCharCategoryTypes(node.getBegin()).contains((Object)CategoryType.NOOOVBOW);
    }
}

