/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputText;
import com.worksap.nlp.sudachi.Lattice;
import com.worksap.nlp.sudachi.LatticeNode;
import com.worksap.nlp.sudachi.NumericParser;
import com.worksap.nlp.sudachi.PathRewritePlugin;
import com.worksap.nlp.sudachi.dictionary.CategoryType;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

class JoinNumericPlugin
extends PathRewritePlugin {
    static final List<String> NUMERIC_POS = Arrays.asList("\u540d\u8a5e", "\u6570\u8a5e", "*", "*", "*", "*");
    boolean enableNormalize;
    short numericPOSId;

    JoinNumericPlugin() {
    }

    @Override
    public void setUp(Grammar grammar) {
        this.enableNormalize = this.settings.getBoolean("enableNormalize", true);
        this.numericPOSId = grammar.getPartOfSpeechId(NUMERIC_POS);
    }

    @Override
    public void rewrite(InputText text, List<LatticeNode> path, Lattice lattice) {
        int beginIndex = -1;
        boolean commaAsDigit = true;
        boolean periodAsDigit = true;
        NumericParser parser = new NumericParser();
        block0: for (int i = 0; i < path.size(); ++i) {
            LatticeNode node = path.get(i);
            Set<CategoryType> types = this.getCharCategoryTypes(text, node);
            String s = node.getWordInfo().getNormalizedForm();
            if (types.contains((Object)CategoryType.NUMERIC) || types.contains((Object)CategoryType.KANJINUMERIC) || periodAsDigit && s.equals(".") || commaAsDigit && s.equals(",")) {
                if (beginIndex < 0) {
                    parser.clear();
                    beginIndex = i;
                }
                for (int j = 0; j < s.length(); ++j) {
                    char c = s.charAt(j);
                    if (parser.append(c)) continue;
                    if (beginIndex < 0) continue block0;
                    if (parser.errorState == NumericParser.Error.COMMA) {
                        commaAsDigit = false;
                        i = beginIndex - 1;
                    } else if (parser.errorState == NumericParser.Error.POINT) {
                        periodAsDigit = false;
                        i = beginIndex - 1;
                    }
                    beginIndex = -1;
                    continue block0;
                }
                continue;
            }
            if (beginIndex >= 0) {
                if (parser.done()) {
                    this.concat(path, beginIndex, i, lattice, parser);
                    i = beginIndex + 1;
                } else {
                    String ss = path.get(i - 1).getWordInfo().getNormalizedForm();
                    if (parser.errorState == NumericParser.Error.COMMA && ss.equals(",") || parser.errorState == NumericParser.Error.POINT && ss.equals(".")) {
                        this.concat(path, beginIndex, i - 1, lattice, parser);
                        i = beginIndex + 2;
                    }
                }
            }
            beginIndex = -1;
            if (!commaAsDigit && !s.equals(",")) {
                commaAsDigit = true;
            }
            if (periodAsDigit || s.equals(".")) continue;
            periodAsDigit = true;
        }
        if (beginIndex >= 0) {
            if (parser.done()) {
                this.concat(path, beginIndex, path.size(), lattice, parser);
            } else {
                String ss = path.get(path.size() - 1).getWordInfo().getNormalizedForm();
                if (parser.errorState == NumericParser.Error.COMMA && ss.equals(",") || parser.errorState == NumericParser.Error.POINT && ss.equals(".")) {
                    this.concat(path, beginIndex, path.size() - 1, lattice, parser);
                }
            }
        }
    }

    private void concat(List<LatticeNode> path, int begin, int end, Lattice lattice, NumericParser parser) {
        if (path.get(begin).getWordInfo().getPOSId() != this.numericPOSId) {
            return;
        }
        if (this.enableNormalize) {
            String normalizedForm = parser.getNormalized();
            if (end - begin > 1 || !normalizedForm.equals(path.get(begin).getWordInfo().getNormalizedForm())) {
                this.concatenate(path, begin, end, lattice, normalizedForm);
            }
        } else if (end - begin > 1) {
            this.concatenate(path, begin, end, lattice, null);
        }
    }
}

