/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputText;
import com.worksap.nlp.sudachi.LatticeNode;
import com.worksap.nlp.sudachi.OovProviderPlugin;
import com.worksap.nlp.sudachi.dictionary.CategoryType;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

class MeCabOovProviderPlugin
extends OovProviderPlugin {
    Map<CategoryType, CategoryInfo> categories = new EnumMap<CategoryType, CategoryInfo>(CategoryType.class);
    Map<CategoryType, List<OOV>> oovList = new EnumMap<CategoryType, List<OOV>>(CategoryType.class);

    MeCabOovProviderPlugin() {
    }

    @Override
    public void setUp(Grammar grammar) throws IOException {
        String charDef = this.settings.getPath("charDef");
        this.readCharacterProperty(charDef);
        String unkDef = this.settings.getPath("unkDef");
        this.readOOV(unkDef, grammar);
    }

    @Override
    public List<LatticeNode> provideOOV(InputText inputText, int offset, boolean hasOtherWords) {
        ArrayList<LatticeNode> nodes = new ArrayList<LatticeNode>();
        int length = inputText.getCharCategoryContinuousLength(offset);
        if (length > 0) {
            for (CategoryType type : inputText.getCharCategoryTypes(offset)) {
                int sublength;
                CategoryInfo cinfo = this.categories.get((Object)type);
                if (cinfo == null) continue;
                int llength = length;
                List<OOV> oovs = this.oovList.get((Object)cinfo.type);
                if (oovs == null) continue;
                if (cinfo.isGroup && (cinfo.isInvoke || !hasOtherWords)) {
                    String s = inputText.getSubstring(offset, offset + length);
                    for (OOV oov : oovs) {
                        nodes.add(this.getOOVNode(s, oov, length));
                    }
                    --llength;
                }
                if (!cinfo.isInvoke && hasOtherWords) continue;
                for (int i = 1; i <= cinfo.length && (sublength = inputText.getCodePointsOffsetLength(offset, i)) <= llength; ++i) {
                    String s = inputText.getSubstring(offset, offset + sublength);
                    for (OOV oov : oovs) {
                        nodes.add(this.getOOVNode(s, oov, sublength));
                    }
                }
            }
        }
        return nodes;
    }

    LatticeNode getOOVNode(String text, OOV oov, int length) {
        LatticeNode node = this.createNode();
        node.setParameter(oov.leftId, oov.rightId, oov.cost);
        WordInfo info = new WordInfo(text, (short)length, oov.posId, text, text, "");
        node.setWordInfo(info);
        return node;
    }

    void readCharacterProperty(String charDef) throws IOException {
        try (InputStream input = charDef == null ? this.openFromJar("char.def") : new FileInputStream(charDef);
             InputStreamReader isReader = new InputStreamReader(input, StandardCharsets.UTF_8);
             LineNumberReader reader = new LineNumberReader(isReader);){
            String line = reader.readLine();
            while (line != null) {
                if (!(line.matches("\\s*") || line.startsWith("#") || line.startsWith("0x"))) {
                    CategoryType type;
                    String[] cols = line.split("\\s+");
                    if (cols.length < 4) {
                        throw new IllegalArgumentException("invalid format at line " + reader.getLineNumber());
                    }
                    try {
                        type = CategoryType.valueOf(cols[0]);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(cols[0] + " is invalid type at line " + reader.getLineNumber(), e);
                    }
                    if (this.categories.containsKey((Object)type)) {
                        throw new IllegalArgumentException(cols[0] + " is already defined at line " + reader.getLineNumber());
                    }
                    CategoryInfo info = new CategoryInfo();
                    info.type = type;
                    info.isInvoke = !cols[1].equals("0");
                    info.isGroup = !cols[2].equals("0");
                    info.length = Integer.parseInt(cols[3]);
                    this.categories.put(type, info);
                }
                line = reader.readLine();
            }
        }
    }

    void readOOV(String unkDef, Grammar grammar) throws IOException {
        try (InputStream input = unkDef == null ? this.openFromJar("unk.def") : new FileInputStream(unkDef);
             InputStreamReader isReader = new InputStreamReader(input, StandardCharsets.UTF_8);
             LineNumberReader reader = new LineNumberReader(isReader);){
            String line = reader.readLine();
            while (line != null) {
                CategoryType type;
                String[] cols = line.split(",");
                if (cols.length < 10) {
                    throw new IllegalArgumentException("invalid format at line " + reader.getLineNumber());
                }
                try {
                    type = CategoryType.valueOf(cols[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(cols[0] + " is invalid type at line " + reader.getLineNumber(), e);
                }
                if (!this.categories.containsKey((Object)type)) {
                    throw new IllegalArgumentException(cols[0] + " is undefined at line " + reader.getLineNumber());
                }
                OOV oov = new OOV();
                oov.leftId = Short.parseShort(cols[1]);
                oov.rightId = Short.parseShort(cols[2]);
                oov.cost = Short.parseShort(cols[3]);
                List<String> pos = Arrays.asList(cols[4], cols[5], cols[6], cols[7], cols[8], cols[9]);
                oov.posId = grammar.getPartOfSpeechId(pos);
                this.oovList.computeIfAbsent(type, t -> new ArrayList()).add(oov);
                line = reader.readLine();
            }
        }
    }

    private InputStream openFromJar(String path) {
        return MeCabOovProviderPlugin.class.getClassLoader().getResourceAsStream(path);
    }

    static class OOV {
        short leftId;
        short rightId;
        short cost;
        short posId;

        OOV() {
        }
    }

    static class CategoryInfo {
        CategoryType type;
        boolean isInvoke;
        boolean isGroup;
        int length;

        CategoryInfo() {
        }
    }
}

