/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Morpheme;
import com.worksap.nlp.sudachi.Plugin;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public abstract class MorphemeFormatterPlugin
extends Plugin {
    protected String delimiter;
    protected String eosString;
    protected boolean showDetails;

    public void setUp() throws IOException {
        this.delimiter = this.settings.getString("delimiter", "\n");
        this.eosString = this.settings.getString("eos", "\nEOS\n");
        this.showDetails = false;
    }

    public abstract String formatMorpheme(Morpheme var1);

    public void showDetails() {
        this.showDetails = true;
    }

    void printSentence(List<Morpheme> sentence, PrintStream output) {
        boolean isFirst = true;
        for (Morpheme m : sentence) {
            if (isFirst) {
                isFirst = false;
            } else {
                output.print(this.delimiter);
            }
            output.print(this.formatMorpheme(m));
        }
        output.print(this.eosString);
    }
}

