/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Morpheme;
import com.worksap.nlp.sudachi.MorphemeList;
import com.worksap.nlp.sudachi.Tokenizer;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import java.util.List;

class MorphemeImpl
implements Morpheme {
    final MorphemeList list;
    final int index;
    WordInfo wordInfo;

    MorphemeImpl(MorphemeList list, int index) {
        this.list = list;
        this.index = index;
    }

    @Override
    public int begin() {
        return this.list.getBegin(this.index);
    }

    @Override
    public int end() {
        return this.list.getEnd(this.index);
    }

    @Override
    public String surface() {
        return this.list.getSurface(this.index);
    }

    @Override
    public List<String> partOfSpeech() {
        WordInfo wi = this.getWordInfo();
        return this.list.grammar.getPartOfSpeechString(wi.getPOSId());
    }

    @Override
    public short partOfSpeechId() {
        WordInfo wi = this.getWordInfo();
        return wi.getPOSId();
    }

    @Override
    public String dictionaryForm() {
        WordInfo wi = this.getWordInfo();
        return wi.getDictionaryForm();
    }

    @Override
    public String normalizedForm() {
        WordInfo wi = this.getWordInfo();
        return wi.getNormalizedForm();
    }

    @Override
    public String readingForm() {
        WordInfo wi = this.getWordInfo();
        return wi.getReadingForm();
    }

    @Override
    public List<Morpheme> split(Tokenizer.SplitMode mode) {
        WordInfo wi = this.getWordInfo();
        return this.list.split(mode, this.index, wi);
    }

    @Override
    public boolean isOOV() {
        return this.list.isOOV(this.index);
    }

    @Override
    public int getWordId() {
        return this.list.getWordId(this.index);
    }

    @Override
    public int getDictionaryId() {
        return this.list.getDictionaryId(this.index);
    }

    @Override
    public int[] getSynonymGroupIds() {
        WordInfo wi = this.getWordInfo();
        return wi.getSynonymGoupIds();
    }

    WordInfo getWordInfo() {
        if (this.wordInfo == null) {
            this.wordInfo = this.list.getWordInfo(this.index);
        }
        return this.wordInfo;
    }
}

