/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputTextBuilder;
import com.worksap.nlp.sudachi.InputTextPlugin;
import com.worksap.nlp.sudachi.dictionary.CategoryType;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class IgnoreYomiganaPlugin
extends InputTextPlugin {
    private Set<Integer> leftBracketSet = new HashSet<Integer>();
    private Set<Integer> rightBracketSet = new HashSet<Integer>();
    private int maxYomiganaLength;
    private Grammar grammar;

    IgnoreYomiganaPlugin() {
    }

    @Override
    public void setUp(Grammar grammar) throws IOException {
        this.grammar = grammar;
        List<String> leftBracketString = this.settings.getStringList("leftBrackets");
        for (String s : leftBracketString) {
            this.leftBracketSet.add(s.codePointAt(0));
        }
        List<String> rightBracketString = this.settings.getStringList("rightBrackets");
        for (String s : rightBracketString) {
            this.rightBracketSet.add(s.codePointAt(0));
        }
        this.maxYomiganaLength = this.settings.getInt("maxYomiganaLength", 4);
    }

    @Override
    public void rewrite(InputTextBuilder builder) {
        String text = builder.getText();
        int n = text.length();
        int startBracketPoint = -1;
        int offset = 0;
        boolean hasYomigana = false;
        for (int i = 1; i < n; ++i) {
            int cp = text.codePointAt(i);
            if (this.isKanji(text.codePointAt(i - 1)).booleanValue() && this.leftBracketSet.contains(cp)) {
                startBracketPoint = i;
                continue;
            }
            if (hasYomigana && this.rightBracketSet.contains(cp)) {
                builder.replace(startBracketPoint - 1 - offset, i + 1 - offset, text.substring(startBracketPoint - 1, startBracketPoint));
                offset += i - startBracketPoint + 1;
                startBracketPoint = -1;
                hasYomigana = false;
                continue;
            }
            if (startBracketPoint == -1) continue;
            if ((this.isHiragana(cp).booleanValue() || this.isKatakana(cp).booleanValue()) && i - startBracketPoint <= this.maxYomiganaLength) {
                hasYomigana = true;
                continue;
            }
            startBracketPoint = -1;
            hasYomigana = false;
        }
    }

    private Boolean isKanji(int cp) {
        return this.grammar.getCharacterCategory().getCategoryTypes(cp).contains((Object)CategoryType.KANJI);
    }

    private Boolean isHiragana(int cp) {
        return this.grammar.getCharacterCategory().getCategoryTypes(cp).contains((Object)CategoryType.HIRAGANA);
    }

    private Boolean isKatakana(int cp) {
        return this.grammar.getCharacterCategory().getCategoryTypes(cp).contains((Object)CategoryType.KATAKANA);
    }
}

