/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Dictionary;
import com.worksap.nlp.sudachi.EditConnectionCostPlugin;
import com.worksap.nlp.sudachi.InputTextPlugin;
import com.worksap.nlp.sudachi.JapaneseTokenizer;
import com.worksap.nlp.sudachi.OovProviderPlugin;
import com.worksap.nlp.sudachi.PathRewritePlugin;
import com.worksap.nlp.sudachi.Settings;
import com.worksap.nlp.sudachi.SudachiCommandLine;
import com.worksap.nlp.sudachi.Tokenizer;
import com.worksap.nlp.sudachi.dictionary.BinaryDictionary;
import com.worksap.nlp.sudachi.dictionary.CharacterCategory;
import com.worksap.nlp.sudachi.dictionary.DoubleArrayLexicon;
import com.worksap.nlp.sudachi.dictionary.GrammarImpl;
import com.worksap.nlp.sudachi.dictionary.LexiconSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class JapaneseDictionary
implements Dictionary {
    GrammarImpl grammar;
    LexiconSet lexicon;
    List<InputTextPlugin> inputTextPlugins;
    List<OovProviderPlugin> oovProviderPlugins;
    List<PathRewritePlugin> pathRewritePlugins;
    List<BinaryDictionary> dictionaries;
    boolean allowEmptyMorpheme;

    JapaneseDictionary() throws IOException {
        this(null, null, false);
    }

    JapaneseDictionary(String jsonString) throws IOException {
        this(null, jsonString, false);
    }

    JapaneseDictionary(String path, String jsonString, boolean mergeSettings) throws IOException {
        Settings settings = JapaneseDictionary.buildSettings(path, jsonString, mergeSettings);
        this.dictionaries = new ArrayList<BinaryDictionary>();
        this.readSystemDictionary(settings.getPath("systemDict"));
        for (EditConnectionCostPlugin editConnectionCostPlugin : settings.getPluginList("editConnectionCostPlugin")) {
            editConnectionCostPlugin.setUp(this.grammar);
            editConnectionCostPlugin.edit(this.grammar);
        }
        this.readCharacterDefinition(settings.getPath("characterDefinitionFile"));
        this.inputTextPlugins = settings.getPluginList("inputTextPlugin");
        for (InputTextPlugin inputTextPlugin : this.inputTextPlugins) {
            inputTextPlugin.setUp(this.grammar);
        }
        this.oovProviderPlugins = settings.getPluginList("oovProviderPlugin");
        if (this.oovProviderPlugins.isEmpty()) {
            throw new IllegalArgumentException("no OOV provider");
        }
        for (OovProviderPlugin oovProviderPlugin : this.oovProviderPlugins) {
            oovProviderPlugin.setUp(this.grammar);
        }
        this.pathRewritePlugins = settings.getPluginList("pathRewritePlugin");
        for (PathRewritePlugin pathRewritePlugin : this.pathRewritePlugins) {
            pathRewritePlugin.setUp(this.grammar);
        }
        for (String string : settings.getPathList("userDict")) {
            this.readUserDictionary(string);
        }
        this.allowEmptyMorpheme = settings.getBoolean("allowEmptyMorpheme", true);
    }

    static Settings buildSettings(String path, String jsonString, boolean mergeSettings) throws IOException {
        Settings defaultSettings;
        try (InputStream input = SudachiCommandLine.class.getResourceAsStream("/sudachi.json");){
            defaultSettings = Settings.parseSettings(path, JapaneseDictionary.readAll(input));
        }
        if (jsonString == null) {
            return defaultSettings;
        }
        if (mergeSettings) {
            defaultSettings.merge(Settings.parseSettings(path, jsonString));
            return defaultSettings;
        }
        return Settings.parseSettings(path, jsonString);
    }

    void readSystemDictionary(String filename) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException("system dictionary is not specified");
        }
        BinaryDictionary dictionary = BinaryDictionary.readSystemDictionary(filename);
        this.dictionaries.add(dictionary);
        this.grammar = dictionary.getGrammar();
        this.lexicon = new LexiconSet(dictionary.getLexicon());
    }

    void readUserDictionary(String filename) throws IOException {
        if (this.lexicon.isFull()) {
            throw new IllegalArgumentException("too many dictionaries");
        }
        BinaryDictionary dictionary = BinaryDictionary.readUserDictionary(filename);
        this.dictionaries.add(dictionary);
        DoubleArrayLexicon userLexicon = dictionary.getLexicon();
        JapaneseTokenizer tokenizer = new JapaneseTokenizer(this.grammar, this.lexicon, this.inputTextPlugins, this.oovProviderPlugins, Collections.emptyList());
        userLexicon.calculateCost(tokenizer);
        this.lexicon.add(userLexicon, (short)this.grammar.getPartOfSpeechSize());
        this.grammar.addPosList(dictionary.getGrammar());
    }

    void readCharacterDefinition(String filename) throws IOException {
        if (this.grammar == null) {
            return;
        }
        CharacterCategory charCategory = new CharacterCategory();
        charCategory.readCharacterDefinition(filename);
        this.grammar.setCharacterCategory(charCategory);
    }

    @Override
    public void close() throws IOException {
        this.grammar = null;
        this.lexicon = null;
        for (BinaryDictionary dictionary : this.dictionaries) {
            dictionary.close();
        }
    }

    @Override
    public Tokenizer create() {
        JapaneseTokenizer tokenizer = new JapaneseTokenizer(this.grammar, this.lexicon, this.inputTextPlugins, this.oovProviderPlugins, this.pathRewritePlugins);
        if (!this.allowEmptyMorpheme) {
            tokenizer.disableEmptyMorpheme();
        }
        return tokenizer;
    }

    @Override
    public int getPartOfSpeechSize() {
        return this.grammar.getPartOfSpeechSize();
    }

    @Override
    public List<String> getPartOfSpeechString(short posId) {
        return this.grammar.getPartOfSpeechString(posId);
    }

    static String readAll(InputStream input) throws IOException {
        try (InputStreamReader isReader = new InputStreamReader(input, StandardCharsets.UTF_8);){
            String string;
            try (BufferedReader reader = new BufferedReader(isReader);){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                string = sb.toString();
            }
            return string;
        }
    }
}

