/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Lattice;
import com.worksap.nlp.sudachi.LatticeNode;
import com.worksap.nlp.sudachi.LatticeNodeImpl;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

class LatticeImpl
implements Lattice {
    private ArrayList<List<LatticeNodeImpl>> endLists;
    private int size;
    private int capacity;
    private LatticeNodeImpl eosNode;
    private Grammar grammar;
    private short[] eosParams;

    LatticeImpl(Grammar grammar) {
        this.grammar = grammar;
        this.eosParams = grammar.getEOSParameter();
        this.endLists = new ArrayList();
        LatticeNodeImpl bosNode = new LatticeNodeImpl();
        short[] bosParams = grammar.getBOSParameter();
        bosNode.setParameter(bosParams[0], bosParams[1], bosParams[2]);
        bosNode.isConnectedToBOS = true;
        this.endLists.add(Collections.singletonList(bosNode));
    }

    void resize(int size) {
        if (size > this.capacity) {
            this.expand(size);
        }
        this.size = size;
        this.eosNode = new LatticeNodeImpl();
        this.eosNode.setParameter(this.eosParams[0], this.eosParams[1], this.eosParams[2]);
        this.eosNode.begin = this.eosNode.end = size;
    }

    void clear() {
        for (int i = 1; i < this.size + 1; ++i) {
            this.endLists.get(i).clear();
        }
        this.size = 0;
        this.eosNode = null;
    }

    void expand(int newSize) {
        this.endLists.ensureCapacity(newSize + 1);
        for (int i = this.size + 1; i < newSize + 1; ++i) {
            this.endLists.add(new ArrayList());
        }
        this.capacity = newSize;
    }

    public List<LatticeNodeImpl> getNodesWithEnd(int end) {
        return this.endLists.get(end);
    }

    public List<LatticeNodeImpl> getNodes(int begin, int end) {
        return this.endLists.get(end).stream().filter(n -> n.getBegin() == begin).collect(Collectors.toList());
    }

    public Optional<LatticeNodeImpl> getMinimumNode(int begin, int end) {
        return this.endLists.get(end).stream().filter(n -> n.getBegin() == begin).min((l, r) -> l.cost - r.cost);
    }

    @Override
    public void insert(int begin, int end, LatticeNode node) {
        LatticeNodeImpl n = (LatticeNodeImpl)node;
        this.endLists.get(end).add(n);
        n.begin = begin;
        n.end = end;
        this.connectNode(n);
    }

    @Override
    public void remove(int begin, int end, LatticeNode node) {
        this.endLists.get(end).remove(node);
    }

    @Override
    public LatticeNode createNode() {
        return new LatticeNodeImpl();
    }

    boolean hasPreviousNode(int index) {
        return !this.endLists.get(index).isEmpty();
    }

    void connectNode(LatticeNodeImpl rNode) {
        int begin = rNode.begin;
        rNode.totalCost = Integer.MAX_VALUE;
        for (LatticeNodeImpl lNode : this.endLists.get(begin)) {
            int cost;
            short connectCost;
            if (!lNode.isConnectedToBOS || (connectCost = this.grammar.getConnectCost(lNode.rightId, rNode.leftId)) == Short.MAX_VALUE || (cost = lNode.totalCost + connectCost) >= rNode.totalCost) continue;
            rNode.totalCost = cost;
            rNode.bestPreviousNode = lNode;
        }
        rNode.isConnectedToBOS = rNode.bestPreviousNode != null;
        rNode.totalCost += rNode.cost;
    }

    void connectEosNode() {
        this.connectNode(this.eosNode);
    }

    List<LatticeNode> getBestPath() {
        if (!this.eosNode.isConnectedToBOS) {
            throw new IllegalStateException("EOS isn't connected to BOS");
        }
        ArrayList<LatticeNode> result = new ArrayList<LatticeNode>();
        LatticeNodeImpl node = this.eosNode.bestPreviousNode;
        while (node != this.endLists.get(0).get(0)) {
            result.add(node);
            node = node.bestPreviousNode;
        }
        Collections.reverse(result);
        return result;
    }

    String getSurface(LatticeNodeImpl node) {
        return node.isDefined ? node.getWordInfo().getSurface() : "(null)";
    }

    String getPos(LatticeNodeImpl node) {
        if (!node.isDefined) {
            return "BOS/EOS";
        }
        WordInfo wi = node.getWordInfo();
        short posId = wi.getPOSId();
        return posId < 0 ? "(null)" : String.join((CharSequence)",", this.grammar.getPartOfSpeechString(posId));
    }

    void dump(PrintStream output) {
        int index = 0;
        for (int i = this.size + 1; i >= 0; --i) {
            List<LatticeNodeImpl> rNodes = i <= this.size ? this.endLists.get(i) : Collections.singletonList(this.eosNode);
            for (LatticeNodeImpl rNode : rNodes) {
                String surface = this.getSurface(rNode);
                String pos = this.getPos(rNode);
                output.print(String.format("%d: %d %d %s(%d) %s %d %d %d: ", index, rNode.getBegin(), rNode.getEnd(), surface, rNode.wordId, pos, rNode.leftId, rNode.rightId, rNode.cost));
                ++index;
                for (LatticeNodeImpl lNode : this.endLists.get(rNode.begin)) {
                    short cost = this.grammar.getConnectCost(lNode.rightId, rNode.leftId);
                    output.print(String.format("%d ", cost));
                }
                output.println();
            }
        }
    }

    JsonObjectBuilder nodeToJson(LatticeNodeImpl node) {
        String surface = this.getSurface(node);
        String pos = this.getPos(node);
        int begin = node.getBegin();
        int end = node.getEnd();
        return Json.createObjectBuilder().add("begin", (JsonValue)(begin == end && begin == 0 ? JsonValue.NULL : Json.createValue((int)begin))).add("end", (JsonValue)(begin == end && begin != 0 ? JsonValue.NULL : Json.createValue((int)end))).add("headword", surface).add("wordId", node.wordId).add("pos", pos).add("leftId", (int)node.leftId).add("rightId", (int)node.rightId).add("cost", (int)node.cost);
    }

    JsonArrayBuilder toJson() {
        JsonArrayBuilder lattice = Json.createArrayBuilder();
        int nodeId = 0;
        for (int i = 0; i <= this.size + 1; ++i) {
            List<LatticeNodeImpl> rNodes = i <= this.size ? this.endLists.get(i) : Collections.singletonList(this.eosNode);
            for (LatticeNodeImpl rNode : rNodes) {
                JsonObjectBuilder node = this.nodeToJson(rNode).add("nodeId", nodeId++);
                JsonArrayBuilder connectCosts = Json.createArrayBuilder();
                for (LatticeNodeImpl lNode : this.endLists.get(rNode.begin)) {
                    short cost = this.grammar.getConnectCost(lNode.rightId, rNode.leftId);
                    connectCosts.add((int)cost);
                }
                node.add("connectCosts", connectCosts);
                lattice.add(node);
            }
        }
        return lattice;
    }
}

