/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Objects;

public class MMap {
    private MMap() {
    }

    public static ByteBuffer map(String filename) throws IOException {
        try (FileInputStream istream = new FileInputStream(filename);){
            MappedByteBuffer mappedByteBuffer;
            block11: {
                FileChannel inputFile = istream.getChannel();
                try {
                    MappedByteBuffer buffer = inputFile.map(FileChannel.MapMode.READ_ONLY, 0L, inputFile.size());
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    mappedByteBuffer = buffer;
                    if (inputFile == null) break block11;
                }
                catch (Throwable throwable) {
                    if (inputFile != null) {
                        try {
                            inputFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputFile.close();
            }
            return mappedByteBuffer;
        }
    }

    public static void unmap(ByteBuffer buffer) throws IOException {
        if (!buffer.isDirect()) {
            return;
        }
        MethodHandle unmapper = null;
        Class unmappableBufferClass = null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            try {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                MethodHandle cleanerMethod = lookup.findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
                Field f = unsafeClass.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                Object theUnsafe = f.get(null);
                unmapper = cleanerMethod.bindTo(theUnsafe);
                unmappableBufferClass = ByteBuffer.class;
            }
            catch (SecurityException se) {
                throw se;
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                Class<?> directBufferClass = Class.forName("java.nio.DirectByteBuffer");
                Method m = directBufferClass.getMethod("cleaner", new Class[0]);
                m.setAccessible(true);
                MethodHandle directBufferCleanerMethod = lookup.unreflect(m);
                TypeDescriptor.OfField cleanerClass = directBufferCleanerMethod.type().returnType();
                MethodHandle cleanMethod = lookup.findVirtual((Class<?>)cleanerClass, "clean", MethodType.methodType(Void.TYPE));
                MethodHandle nonNullTest = lookup.findStatic(Objects.class, "nonNull", MethodType.methodType(Boolean.TYPE, Object.class)).asType(MethodType.methodType(Boolean.TYPE, cleanerClass));
                MethodHandle noop = MethodHandles.dropArguments(MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE)), 0, new Class[]{cleanerClass});
                unmapper = MethodHandles.filterReturnValue(directBufferCleanerMethod, MethodHandles.guardWithTest(nonNullTest, cleanMethod, noop)).asType(MethodType.methodType(Void.TYPE, ByteBuffer.class));
                unmappableBufferClass = directBufferClass;
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (ReflectiveOperationException | RuntimeException ignored) {
            unmapper = null;
        }
        if (unmapper != null && unmappableBufferClass.isInstance(buffer)) {
            try {
                unmapper.invokeExact(buffer);
            }
            catch (Throwable e) {
                throw new IOException("can not destroy direct buffer " + buffer, e);
            }
        }
    }
}

