/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Morpheme;
import com.worksap.nlp.sudachi.MorphemeFormatterPlugin;
import java.io.IOException;
import java.util.Arrays;

public class SimpleMorphemeFormatter
extends MorphemeFormatterPlugin {
    protected String columnDelimiter;

    @Override
    public void setUp() throws IOException {
        super.setUp();
        this.columnDelimiter = this.settings.getString("columnDelimiter", "\t");
    }

    @Override
    public String formatMorpheme(Morpheme morpheme) {
        String output = morpheme.surface() + this.columnDelimiter + String.join((CharSequence)",", morpheme.partOfSpeech()) + this.columnDelimiter + morpheme.normalizedForm();
        if (this.showDetails) {
            output = output + this.columnDelimiter + morpheme.dictionaryForm() + this.columnDelimiter + morpheme.readingForm() + this.columnDelimiter + morpheme.getDictionaryId() + this.columnDelimiter + Arrays.toString(morpheme.getSynonymGroupIds()) + this.columnDelimiter + (morpheme.isOOV() ? "(OOV)" : "");
        }
        return output;
    }
}

