/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Dictionary;
import com.worksap.nlp.sudachi.DictionaryFactory;
import com.worksap.nlp.sudachi.JapaneseDictionary;
import com.worksap.nlp.sudachi.Morpheme;
import com.worksap.nlp.sudachi.MorphemeFormatterPlugin;
import com.worksap.nlp.sudachi.Settings;
import com.worksap.nlp.sudachi.Tokenizer;
import java.io.BufferedReader;
import java.io.Console;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class SudachiCommandLine {
    static Logger logger;

    static void run(Tokenizer tokenizer, Tokenizer.SplitMode mode, InputStream input, PrintStream output, MorphemeFormatterPlugin formatter, boolean ignoreError, boolean isFileInput, boolean isWordSegmentation) throws IOException {
        try (InputStreamReader inputReader = isFileInput ? new InputStreamReader(input, "UTF-8") : new InputStreamReader(input);
             BufferedReader reader = new BufferedReader(inputReader);){
            String line = reader.readLine();
            while (line != null) {
                try {
                    for (List<Morpheme> sentence : tokenizer.tokenizeSentences(mode, line)) {
                        formatter.printSentence(sentence, output);
                    }
                    if (isWordSegmentation) {
                        output.print("\n");
                    }
                }
                catch (RuntimeException e) {
                    if (ignoreError) {
                        logger.warning(e.getMessage() + "\n");
                    }
                    throw e;
                }
                line = reader.readLine();
            }
        }
    }

    static MorphemeFormatterPlugin getFormatter(String path, String jsonString, boolean mergeSettings, boolean isWordSegmentation, boolean isLineBreakAtEosInWordSegmentation) throws IOException {
        Settings settings = JapaneseDictionary.buildSettings(path, jsonString, mergeSettings);
        List formatters = settings.getPluginList("formatterPlugin");
        if (formatters.isEmpty()) {
            throw new IllegalArgumentException("no morpheme formatter");
        }
        MorphemeFormatterPlugin formatter = isWordSegmentation ? (isLineBreakAtEosInWordSegmentation ? (MorphemeFormatterPlugin)formatters.get(1) : (MorphemeFormatterPlugin)formatters.get(2)) : (MorphemeFormatterPlugin)formatters.get(0);
        formatter.setUp();
        return formatter;
    }

    public static void main(String[] args) throws IOException {
        block47: {
            InputStream is = SudachiCommandLine.class.getResourceAsStream("/logger.properties");
            if (is != null) {
                LogManager.getLogManager().readConfiguration(is);
            }
            logger = Logger.getLogger(SudachiCommandLine.class.getName());
            Tokenizer.SplitMode mode = Tokenizer.SplitMode.C;
            String settings = null;
            boolean mergeSettings = false;
            String resourcesDirectory = null;
            String outputFileName = null;
            boolean isEnableDump = false;
            boolean showDetails = false;
            boolean ignoreError = false;
            boolean isWordSegmentation = false;
            boolean isLineBreakAtEosInWordSegmentation = true;
            int i = 0;
            for (i = 0; i < args.length; ++i) {
                if (args[i].equals("-r") && i + 1 < args.length) {
                    try (Object input = new FileInputStream(args[++i]);){
                        settings = JapaneseDictionary.readAll((InputStream)input);
                        mergeSettings = false;
                        continue;
                    }
                }
                if (args[i].equals("-p") && i + 1 < args.length) {
                    resourcesDirectory = args[++i];
                    continue;
                }
                if (args[i].equals("-s") && i + 1 < args.length) {
                    settings = args[++i];
                    mergeSettings = true;
                    continue;
                }
                if (args[i].equals("-m") && i + 1 < args.length) {
                    switch (args[++i]) {
                        case "A": {
                            mode = Tokenizer.SplitMode.A;
                            break;
                        }
                        case "B": {
                            mode = Tokenizer.SplitMode.B;
                            break;
                        }
                        default: {
                            mode = Tokenizer.SplitMode.C;
                            break;
                        }
                    }
                    continue;
                }
                if (args[i].equals("-o") && i + 1 < args.length) {
                    outputFileName = args[++i];
                    continue;
                }
                if (args[i].equals("-a")) {
                    showDetails = true;
                    continue;
                }
                if (args[i].equals("-d")) {
                    isEnableDump = true;
                    continue;
                }
                if (args[i].equals("-f")) {
                    ignoreError = true;
                    continue;
                }
                if (args[i].equals("-t")) {
                    isWordSegmentation = true;
                    isLineBreakAtEosInWordSegmentation = false;
                    continue;
                }
                if (args[i].equals("-ts")) {
                    isWordSegmentation = true;
                    isLineBreakAtEosInWordSegmentation = true;
                    continue;
                }
                if (!args[i].equals("-h")) break;
                Console console = System.console();
                console.printf("usage: SudachiCommandLine [-r file] [-m A|B|C] [-o file] [file ...]\n", new Object[0]);
                console.printf("\t-r file\tread settings from file (overrides -s)\n", new Object[0]);
                console.printf("\t-s string\tadditional settings (overrides -r)\n", new Object[0]);
                console.printf("\t-p directory\troot directory of resources\n", new Object[0]);
                console.printf("\t-m mode\tmode of splitting\n", new Object[0]);
                console.printf("\t-o file\toutput to file\n", new Object[0]);
                console.printf("\t-t\tseparate words with spaces\n", new Object[0]);
                console.printf("\t-ts\tseparate words with spaces, and break line for each sentence\n", new Object[0]);
                console.printf("\t-a\tshow details\n", new Object[0]);
                console.printf("\t-f\tignore error\n", new Object[0]);
                console.printf("\t-d\tdebug mode\n", new Object[0]);
                return;
            }
            MorphemeFormatterPlugin formatter = SudachiCommandLine.getFormatter(resourcesDirectory, settings, mergeSettings, isWordSegmentation, isLineBreakAtEosInWordSegmentation);
            if (showDetails) {
                formatter.showDetails();
            }
            try (FileOrStdoutPrintStream output = outputFileName == null ? new FileOrStdoutPrintStream() : new FileOrStdoutPrintStream(outputFileName);
                 Dictionary dict = new DictionaryFactory().create(resourcesDirectory, settings, mergeSettings);){
                Tokenizer tokenizer = dict.create();
                if (isEnableDump) {
                    tokenizer.setDumpOutput(output);
                }
                if (i < args.length) {
                    while (i < args.length) {
                        try (FileInputStream input = new FileInputStream(args[i]);){
                            SudachiCommandLine.run(tokenizer, mode, input, output, formatter, ignoreError, false, isWordSegmentation);
                        }
                        ++i;
                    }
                    break block47;
                }
                SudachiCommandLine.run(tokenizer, mode, System.in, output, formatter, ignoreError, true, isWordSegmentation);
            }
        }
    }

    static class FileOrStdoutPrintStream
    extends PrintStream {
        private boolean isFile;

        FileOrStdoutPrintStream() {
            super(System.out, true);
            this.isFile = false;
        }

        FileOrStdoutPrintStream(String fileName) throws FileNotFoundException, UnsupportedEncodingException {
            super((OutputStream)new FileOutputStream(fileName), false, "UTF-8");
            this.isFile = true;
        }

        @Override
        public void close() {
            if (this.isFile) {
                super.close();
            } else {
                this.flush();
            }
        }
    }
}

