/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.dartsclone.DoubleArray;
import com.worksap.nlp.sudachi.MorphemeList;
import com.worksap.nlp.sudachi.Tokenizer;
import com.worksap.nlp.sudachi.dictionary.Lexicon;
import com.worksap.nlp.sudachi.dictionary.WordIdTable;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import com.worksap.nlp.sudachi.dictionary.WordInfoList;
import com.worksap.nlp.sudachi.dictionary.WordParameterList;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;

public class DoubleArrayLexicon
implements Lexicon {
    static final int USER_DICT_COST_PAR_MORPH = -20;
    private WordIdTable wordIdTable;
    private WordParameterList wordParams;
    private WordInfoList wordInfos;
    private DoubleArray trie = new DoubleArray();

    public DoubleArrayLexicon(ByteBuffer bytes, int offset, boolean hasSynonymGid) {
        int size = bytes.getInt(offset);
        ((Buffer)bytes).position(offset += 4);
        IntBuffer array = bytes.asIntBuffer();
        this.trie.setArray(array, size);
        this.wordIdTable = new WordIdTable(bytes, offset += this.trie.totalSize());
        this.wordParams = new WordParameterList(bytes, offset += this.wordIdTable.storageSize());
        this.wordInfos = new WordInfoList(bytes, offset += this.wordParams.storageSize(), this.wordParams.size(), hasSynonymGid);
    }

    @Override
    public Iterator<int[]> lookup(byte[] text, int offset) {
        Iterator iterator = this.trie.commonPrefixSearch(text, offset);
        if (!iterator.hasNext()) {
            return iterator;
        }
        return new Itr(iterator);
    }

    @Override
    public int getWordId(String headword, short posId, String readingForm) {
        for (int wid = 0; wid < this.wordInfos.size(); ++wid) {
            WordInfo info = this.wordInfos.getWordInfo(wid);
            if (!info.getSurface().equals(headword) || info.getPOSId() != posId || !info.getReadingForm().equals(readingForm)) continue;
            return wid;
        }
        return -1;
    }

    @Override
    public short getLeftId(int wordId) {
        return this.wordParams.getLeftId(wordId);
    }

    @Override
    public short getRightId(int wordId) {
        return this.wordParams.getRightId(wordId);
    }

    @Override
    public short getCost(int wordId) {
        return this.wordParams.getCost(wordId);
    }

    @Override
    public WordInfo getWordInfo(int wordId) {
        return this.wordInfos.getWordInfo(wordId);
    }

    @Override
    public int getDictionaryId(int wordId) {
        return 0;
    }

    @Override
    public int size() {
        return this.wordParams.size();
    }

    public void calculateCost(Tokenizer tokenizer) {
        for (int wordId = 0; wordId < this.wordParams.size(); ++wordId) {
            if (this.getCost(wordId) != Short.MIN_VALUE) continue;
            String surface = this.getWordInfo(wordId).getSurface();
            MorphemeList ms = (MorphemeList)tokenizer.tokenize(surface);
            int cost = ms.getInternalCost() + -20 * ms.size();
            if (cost > Short.MAX_VALUE) {
                cost = Short.MAX_VALUE;
            } else if (cost < Short.MIN_VALUE) {
                cost = Short.MIN_VALUE;
            }
            this.wordParams.setCost(wordId, (short)cost);
        }
    }

    private class Itr
    implements Iterator<int[]> {
        private final Iterator<int[]> iterator;
        private Integer[] wordIds;
        private int length;
        private int index;

        Itr(Iterator<int[]> iterator) {
            this.iterator = iterator;
            this.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.index < 0) {
                return this.iterator.hasNext();
            }
            return this.index < this.wordIds.length || this.iterator.hasNext();
        }

        @Override
        public int[] next() {
            if (this.index < 0 || this.index >= this.wordIds.length) {
                int[] p = this.iterator.next();
                this.wordIds = DoubleArrayLexicon.this.wordIdTable.get(p[0]);
                this.length = p[1];
                this.index = 0;
            }
            return new int[]{this.wordIds[this.index++], this.length};
        }
    }
}

