/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.dictionary.BinaryDictionary;
import com.worksap.nlp.sudachi.dictionary.DictionaryBuilder;
import com.worksap.nlp.sudachi.dictionary.DictionaryHeader;
import com.worksap.nlp.sudachi.dictionary.DoubleArrayLexicon;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import com.worksap.nlp.sudachi.dictionary.GrammarImpl;
import com.worksap.nlp.sudachi.dictionary.Lexicon;
import java.io.Console;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;

public class UserDictionaryBuilder
extends DictionaryBuilder {
    Grammar grammar;
    Lexicon systemLexicon;

    UserDictionaryBuilder(Grammar grammar, Lexicon systemLexicon) {
        this.isUserDictionary = true;
        this.grammar = grammar;
        this.systemLexicon = systemLexicon;
    }

    void build(List<String> lexiconPaths, FileOutputStream output) throws IOException {
        this.logger.info("reading the source file...");
        for (String path : lexiconPaths) {
            try (FileInputStream lexiconInput = new FileInputStream(path);){
                this.buildLexicon(path, lexiconInput);
            }
        }
        this.logger.info(() -> String.format(" %,d words%n", this.entries.size()));
        FileChannel outputChannel = output.getChannel();
        this.writeGrammar(null, outputChannel);
        this.writeLexicon(outputChannel);
        outputChannel.close();
    }

    @Override
    short getPosId(String ... posStrings) {
        short posId = this.grammar.getPartOfSpeechId(Arrays.asList(posStrings));
        if (posId < 0) {
            posId = (short)(super.getPosId(posStrings) + this.grammar.getPartOfSpeechSize());
        }
        return posId;
    }

    @Override
    int getWordId(String headword, short posId, String readingForm) {
        int wid = super.getWordId(headword, posId, readingForm);
        if (wid >= 0) {
            return wid | 0x10000000;
        }
        return this.systemLexicon.getWordId(headword, posId, readingForm);
    }

    @Override
    void checkWordId(int wordId) {
        if (wordId >= 0x10000000) {
            super.checkWordId(wordId & 0xFFFFFFF);
        } else if (wordId < 0 || wordId >= this.systemLexicon.size()) {
            throw new IllegalArgumentException("invalid word ID");
        }
    }

    static void printUsage() {
        Console console = System.console();
        console.printf("usage: UserDictionaryBuilder -o file -s file [-d description] files...\n", new Object[0]);
        console.printf("\t-o file\toutput to file\n", new Object[0]);
        console.printf("\t-s file\tsystem dictionary\n", new Object[0]);
        console.printf("\t-d description\tcomment\n", new Object[0]);
    }

    public static void main(String[] args) throws IOException {
        UserDictionaryBuilder.readLoggerConfig();
        String description = "";
        String outputPath = null;
        String sysDictPath = null;
        int i = 0;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-o") && i + 1 < args.length) {
                outputPath = args[++i];
                continue;
            }
            if (args[i].equals("-s") && i + 1 < args.length) {
                sysDictPath = args[++i];
                continue;
            }
            if (args[i].equals("-d") && i + 1 < args.length) {
                description = args[++i];
                continue;
            }
            if (!args[i].equals("-h")) break;
            UserDictionaryBuilder.printUsage();
            return;
        }
        if (args.length <= i || outputPath == null || sysDictPath == null) {
            UserDictionaryBuilder.printUsage();
            return;
        }
        try (BinaryDictionary systemDict = BinaryDictionary.readSystemDictionary(sysDictPath);){
            GrammarImpl grammar = systemDict.getGrammar();
            DoubleArrayLexicon systemLexicon = systemDict.getLexicon();
            List<String> lexiconPaths = Arrays.asList(args).subList(i, args.length);
            DictionaryHeader header = new DictionaryHeader(-3848306685500829776L, Instant.now().getEpochSecond(), description);
            try (FileOutputStream output = new FileOutputStream(outputPath);){
                output.write(header.toByte());
                UserDictionaryBuilder builder = new UserDictionaryBuilder(grammar, systemLexicon);
                builder.build(lexiconPaths, output);
            }
        }
    }
}

