/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Config;
import com.worksap.nlp.sudachi.Dictionary;
import com.worksap.nlp.sudachi.EditConnectionCostPlugin;
import com.worksap.nlp.sudachi.InputTextPlugin;
import com.worksap.nlp.sudachi.JapaneseTokenizer;
import com.worksap.nlp.sudachi.OovProviderPlugin;
import com.worksap.nlp.sudachi.PathAnchor;
import com.worksap.nlp.sudachi.PathRewritePlugin;
import com.worksap.nlp.sudachi.Plugin;
import com.worksap.nlp.sudachi.PosMatcher;
import com.worksap.nlp.sudachi.Tokenizer;
import com.worksap.nlp.sudachi.dictionary.BinaryDictionary;
import com.worksap.nlp.sudachi.dictionary.CharacterCategory;
import com.worksap.nlp.sudachi.dictionary.DictionaryAccess;
import com.worksap.nlp.sudachi.dictionary.DoubleArrayLexicon;
import com.worksap.nlp.sudachi.dictionary.GrammarImpl;
import com.worksap.nlp.sudachi.dictionary.LexiconSet;
import com.worksap.nlp.sudachi.dictionary.POS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public class JapaneseDictionary
implements Dictionary,
DictionaryAccess {
    GrammarImpl grammar;
    LexiconSet lexicon;
    List<InputTextPlugin> inputTextPlugins;
    List<OovProviderPlugin> oovProviderPlugins;
    List<PathRewritePlugin> pathRewritePlugins;
    List<BinaryDictionary> dictionaries = new ArrayList<BinaryDictionary>();
    boolean allowEmptyMorpheme;

    JapaneseDictionary(Config config) throws IOException {
        Plugin instance;
        this.setupSystemDictionary(config);
        for (Config.PluginConf<EditConnectionCostPlugin> pluginConf : config.getEditConnectionCostPlugins()) {
            instance = pluginConf.instantiate(config.getAnchor());
            ((EditConnectionCostPlugin)instance).setUp(this.grammar);
            ((EditConnectionCostPlugin)instance).edit(this.grammar);
        }
        this.setupCharacterDefinition(config);
        this.inputTextPlugins = new ArrayList<InputTextPlugin>();
        for (Config.PluginConf<Plugin> pluginConf : config.getInputTextPlugins()) {
            instance = (InputTextPlugin)pluginConf.instantiate(config.getAnchor());
            ((InputTextPlugin)instance).setUp(this.grammar);
            this.inputTextPlugins.add((InputTextPlugin)instance);
        }
        this.oovProviderPlugins = new ArrayList<OovProviderPlugin>();
        for (Config.PluginConf<Plugin> pluginConf : config.getOovProviderPlugins()) {
            instance = (OovProviderPlugin)pluginConf.instantiate(config.getAnchor());
            ((OovProviderPlugin)instance).setUp(this.grammar);
            this.oovProviderPlugins.add((OovProviderPlugin)instance);
        }
        if (this.oovProviderPlugins.isEmpty()) {
            throw new IllegalArgumentException("there must be at least one OOV provider plugin");
        }
        this.pathRewritePlugins = new ArrayList<PathRewritePlugin>();
        for (Config.PluginConf<Plugin> pluginConf : config.getPathRewritePlugins()) {
            instance = (PathRewritePlugin)pluginConf.instantiate(config.getAnchor());
            ((PathRewritePlugin)instance).setUp(this.grammar);
            this.pathRewritePlugins.add((PathRewritePlugin)instance);
        }
        this.setupUserDictionaries(config);
        this.allowEmptyMorpheme = config.isAllowEmptyMorpheme();
    }

    void setupSystemDictionary(Config config) throws IOException {
        BinaryDictionary dictionary = BinaryDictionary.loadSystem(config.getSystemDictionary());
        this.dictionaries.add(dictionary);
        this.grammar = dictionary.getGrammar();
        this.lexicon = new LexiconSet(dictionary.getLexicon(), this.grammar.getSystemPartOfSpeechSize());
    }

    void setupUserDictionaries(Config config) throws IOException {
        for (Config.Resource<BinaryDictionary> userDic : config.getUserDictionaries()) {
            BinaryDictionary instance = BinaryDictionary.loadUser(userDic);
            this.addUserDictionary(instance);
        }
    }

    void addUserDictionary(BinaryDictionary dictionary) {
        if (this.lexicon.isFull()) {
            throw new IllegalArgumentException("too many dictionaries");
        }
        this.dictionaries.add(dictionary);
        DoubleArrayLexicon userLexicon = dictionary.getLexicon();
        JapaneseTokenizer tokenizer = new JapaneseTokenizer(this.grammar, this.lexicon, this.inputTextPlugins, this.oovProviderPlugins, Collections.emptyList());
        userLexicon.calculateCost(tokenizer);
        this.lexicon.add(userLexicon, (short)this.grammar.getPartOfSpeechSize());
        this.grammar.addPosList(dictionary.getGrammar());
    }

    void setupCharacterDefinition(Config config) throws IOException {
        if (this.grammar == null) {
            return;
        }
        Config.Resource<CharacterCategory> resource = config.getCharacterDefinition();
        if (resource == null) {
            resource = PathAnchor.classpath().resource("char.def");
        }
        CharacterCategory category = CharacterCategory.load(resource);
        this.grammar.setCharacterCategory(category);
    }

    @Override
    public void close() throws IOException {
        this.grammar = null;
        this.lexicon = null;
        for (BinaryDictionary dictionary : this.dictionaries) {
            dictionary.close();
        }
    }

    @Override
    public Tokenizer create() {
        JapaneseTokenizer tokenizer = new JapaneseTokenizer(this.grammar, this.lexicon, this.inputTextPlugins, this.oovProviderPlugins, this.pathRewritePlugins);
        if (!this.allowEmptyMorpheme) {
            tokenizer.disableEmptyMorpheme();
        }
        return tokenizer;
    }

    @Override
    public int getPartOfSpeechSize() {
        return this.grammar.getPartOfSpeechSize();
    }

    @Override
    public List<String> getPartOfSpeechString(short posId) {
        return this.grammar.getPartOfSpeechString(posId);
    }

    static String readAll(InputStream input) throws IOException {
        try (InputStreamReader isReader = new InputStreamReader(input, StandardCharsets.UTF_8);){
            String string;
            try (BufferedReader reader = new BufferedReader(isReader);){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                string = sb.toString();
            }
            return string;
        }
    }

    @Override
    public GrammarImpl getGrammar() {
        return this.grammar;
    }

    @Override
    public LexiconSet getLexicon() {
        return this.lexicon;
    }

    @Override
    public PosMatcher posMatcher(Predicate<POS> predicate) {
        GrammarImpl grammar = this.getGrammar();
        int numPos = grammar.getPartOfSpeechSize();
        int[] ids = IntStream.range(0, numPos).filter(id -> predicate.test(grammar.getPartOfSpeechString((short)id))).toArray();
        return new PosMatcher(ids, this);
    }
}

