/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputText;
import com.worksap.nlp.sudachi.LatticeNode;
import com.worksap.nlp.sudachi.LatticeNodeImpl;
import com.worksap.nlp.sudachi.Morpheme;
import com.worksap.nlp.sudachi.MorphemeImpl;
import com.worksap.nlp.sudachi.Tokenizer;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import com.worksap.nlp.sudachi.dictionary.Lexicon;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MorphemeList
extends AbstractList<Morpheme> {
    final InputText inputText;
    final Grammar grammar;
    final Lexicon lexicon;
    final List<LatticeNode> path;
    final boolean allowEmptyMorpheme;
    final Tokenizer.SplitMode mode;
    public static final MorphemeList EMPTY = new MorphemeList(null, null, null, Collections.emptyList(), true, Tokenizer.SplitMode.C);

    MorphemeList(InputText input, Grammar grammar, Lexicon lexicon, List<LatticeNode> path, boolean allowEmptyMorpheme, Tokenizer.SplitMode mode) {
        this.inputText = input;
        this.grammar = grammar;
        this.lexicon = lexicon;
        this.path = path;
        this.allowEmptyMorpheme = allowEmptyMorpheme;
        this.mode = mode;
    }

    @Override
    public Morpheme get(int index) {
        return new MorphemeImpl(this, index);
    }

    @Override
    public int size() {
        return this.path.size();
    }

    int getBegin(int index) {
        int end;
        int begin = this.inputText.getOriginalIndex(this.path.get(index).getBegin());
        if (!this.allowEmptyMorpheme && begin == (end = this.inputText.getOriginalIndex(this.path.get(index).getEnd())) && index != 0) {
            return this.getBegin(index - 1);
        }
        return begin;
    }

    int getEnd(int index) {
        int begin;
        int end = this.inputText.getOriginalIndex(this.path.get(index).getEnd());
        if (!this.allowEmptyMorpheme && (begin = this.inputText.getOriginalIndex(this.path.get(index).getBegin())) == end && index != 0) {
            return this.getEnd(index - 1);
        }
        return end;
    }

    String getSurface(int index) {
        int begin = this.getBegin(index);
        int end = this.getEnd(index);
        return this.inputText.getOriginalText().substring(begin, end);
    }

    WordInfo getWordInfo(int index) {
        return this.path.get(index).getWordInfo();
    }

    List<Morpheme> split(Tokenizer.SplitMode mode, int index) {
        ArrayList<LatticeNode> nodes = new ArrayList<LatticeNode>();
        LatticeNodeImpl node = (LatticeNodeImpl)this.path.get(index);
        node.appendSplitsTo(nodes, mode);
        return new MorphemeList(this.inputText, this.grammar, this.lexicon, nodes, this.allowEmptyMorpheme, mode);
    }

    public MorphemeList split(Tokenizer.SplitMode mode) {
        if (mode.compareTo(this.mode) >= 0) {
            return this;
        }
        ArrayList<LatticeNode> nodes = new ArrayList<LatticeNode>();
        for (LatticeNode node : this.path) {
            LatticeNodeImpl nodeImpl = (LatticeNodeImpl)node;
            nodeImpl.appendSplitsTo(nodes, mode);
        }
        return new MorphemeList(this.inputText, this.grammar, this.lexicon, nodes, this.allowEmptyMorpheme, mode);
    }

    boolean isOOV(int index) {
        return this.path.get(index).isOOV();
    }

    int getWordId(int index) {
        return this.path.get(index).getWordId();
    }

    int getDictionaryId(int index) {
        return this.path.get(index).getDictionaryId();
    }

    public int getInternalCost() {
        return this.path.get(this.path.size() - 1).getPathCost() - this.path.get(0).getPathCost();
    }
}

