/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.dictionary.POS;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;

public class PartialPOS
extends AbstractList<String> {
    private final List<String> data;

    public PartialPOS(List<String> data) {
        if (data.size() == 0) {
            throw new IllegalArgumentException("Partial POS must have at least 1 component");
        }
        if (data.size() > 6) {
            throw new IllegalArgumentException("Partial POS can have at most 6 components, was " + data);
        }
        for (String component : data) {
            if (component == null || component.length() <= 127) continue;
            throw new IllegalArgumentException("Component length can't be more than 127, was " + component.length() + ":" + component);
        }
        this.data = data;
    }

    public PartialPOS(String ... data) {
        this(Arrays.asList(data));
    }

    @Override
    public String get(int index) {
        return this.data.get(index);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    boolean matches(POS pos) {
        for (int level = 0; level < this.data.size(); ++level) {
            String s = this.data.get(level);
            if (s == null || s.equals(pos.get(level))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return String.join((CharSequence)",", this.data);
    }

    public static PartialPOS of(String ... parts) {
        return new PartialPOS(parts);
    }
}

