/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Config;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.logging.Logger;

public abstract class PathAnchor {
    private static final Logger logger = Logger.getLogger(PathAnchor.class.getName());

    public static PathAnchor classpath() {
        return PathAnchor.classpath(Config.class.getClassLoader());
    }

    public static PathAnchor classpath(ClassLoader loader) {
        return PathAnchor.classpath("", loader);
    }

    public static PathAnchor classpath(String prefix, ClassLoader loader) {
        return new Classpath(Paths.get(prefix, new String[0]), loader);
    }

    public static PathAnchor classpath(Class<?> clz) {
        String name = clz.getName();
        String path = name.replace(".", "/");
        return new Classpath(Paths.get(path, new String[0]).getParent(), clz.getClassLoader());
    }

    public static PathAnchor filesystem(Path path) {
        if (path == null) {
            throw new NullPointerException("passed path was null");
        }
        return new Filesystem(path);
    }

    public static PathAnchor filesystem(String path) {
        if (path == null) {
            throw new NullPointerException("passed path was null");
        }
        return PathAnchor.filesystem(Paths.get(path, new String[0]));
    }

    public static PathAnchor none() {
        return None.INSTANCE;
    }

    public Path resolve(String part) {
        return Paths.get(part, new String[0]);
    }

    public boolean exists(Path path) {
        try {
            return Files.exists(path, new LinkOption[0]);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public <T> Config.Resource<T> toResource(Path path) {
        if (this.exists(path)) {
            return new Config.Resource.Filesystem(path);
        }
        return new Config.Resource.NotFound(path, this);
    }

    public <T> Config.Resource<T> resource(String path) {
        return this.toResource(this.resolve(path));
    }

    public PathAnchor andThen(PathAnchor other) {
        if (this.equals(other)) {
            return this;
        }
        return new Chain(this, other);
    }

    public Class<?> lookupClass(String name) throws ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(name);
    }

    private static class None
    extends PathAnchor {
        private static final None INSTANCE = new None();

        private None() {
        }

        public String toString() {
            return "None{}";
        }

        public boolean equals(Object obj) {
            return obj instanceof None;
        }

        public int hashCode() {
            return 1;
        }
    }

    static class Chain
    extends PathAnchor {
        private final List<PathAnchor> children = new ArrayList<PathAnchor>();

        Chain(PathAnchor ... items) {
            for (PathAnchor item : items) {
                if (item instanceof Chain) {
                    Chain c = (Chain)item;
                    c.children.forEach(this::add);
                    continue;
                }
                this.add(item);
            }
        }

        private void add(PathAnchor item) {
            if (!this.children.contains(item)) {
                this.children.add(item);
            }
        }

        @Override
        public Path resolve(String part) {
            Path path = null;
            for (PathAnchor p : this.children) {
                if (p.exists(path = p.resolve(part))) {
                    return path;
                }
                logger.fine(() -> String.format("%s: %s does not exist, skipping", p, part));
            }
            return path;
        }

        @Override
        public boolean exists(Path path) {
            return this.children.stream().anyMatch(p -> p.exists(path));
        }

        @Override
        public <T> Config.Resource<T> toResource(Path path) {
            for (PathAnchor child : this.children) {
                if (!child.exists(path)) continue;
                return child.toResource(path);
            }
            return new Config.Resource.NotFound(path, this);
        }

        @Override
        public Class<?> lookupClass(String name) throws ClassNotFoundException {
            for (PathAnchor child : this.children) {
                try {
                    return child.lookupClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException(name);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Chain) {
                Chain c = (Chain)obj;
                return this.children.equals(c.children);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.children);
        }

        int count() {
            return this.children.size();
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ", "[", "]");
            for (PathAnchor anchor : this.children) {
                joiner.add(anchor.toString());
            }
            return joiner.toString();
        }
    }

    static class Classpath
    extends PathAnchor {
        private final Path prefix;
        private final ClassLoader loader;

        public Classpath(Path prefix, ClassLoader loader) {
            this.prefix = prefix;
            this.loader = loader;
        }

        @Override
        public Path resolve(String part) {
            Path resolved = this.prefix.resolve(part);
            logger.fine(() -> String.format("%s resolved %s to %s", this, part, resolved));
            return resolved;
        }

        private static String resourceName(Path path) {
            String strPath = path.toString();
            if ("\\".equals(path.getFileSystem().getSeparator())) {
                strPath = strPath.replace("\\", "/");
            }
            return strPath;
        }

        @Override
        public boolean exists(Path path) {
            String name = Classpath.resourceName(path);
            return this.loader.getResource(name) != null;
        }

        @Override
        public <T> Config.Resource<T> toResource(Path path) {
            URL resource = this.loader.getResource(Classpath.resourceName(path));
            if (resource == null) {
                return new Config.Resource.NotFound(path, this);
            }
            return new Config.Resource.Classpath(resource);
        }

        @Override
        public Class<?> lookupClass(String name) throws ClassNotFoundException {
            return this.loader.loadClass(name);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Classpath) {
                Classpath c = (Classpath)obj;
                return this.prefix.equals(c.prefix) && this.loader.equals(c.loader);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.loader);
        }

        public String toString() {
            return "Classpath{prefix=" + this.prefix + '}';
        }
    }

    static class Filesystem
    extends PathAnchor {
        private final Path base;

        public Filesystem(Path base) {
            this.base = base;
        }

        @Override
        public Path resolve(String part) {
            Path resolved = this.base.resolve(part);
            logger.fine(() -> String.format("%s resolved %s to %s", this, part, resolved));
            return resolved;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Filesystem) {
                Filesystem o = (Filesystem)obj;
                return this.base.equals(o.base);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.base);
        }

        public String toString() {
            return "Filesystem{base=" + this.base + '}';
        }
    }
}

