/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputText;
import com.worksap.nlp.sudachi.LatticeNodeImpl;
import com.worksap.nlp.sudachi.OovProviderPlugin;
import com.worksap.nlp.sudachi.Settings;
import com.worksap.nlp.sudachi.WordMask;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import com.worksap.nlp.sudachi.dictionary.POS;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexOovProvider
extends OovProviderPlugin {
    private Pattern pattern;
    private short posId = (short)-1;
    private short cost = Short.MIN_VALUE;
    private short leftId = Short.MIN_VALUE;
    private short rightId = Short.MIN_VALUE;
    private int maxLength = 32;
    private boolean strictBoundaries = true;

    @Override
    public void setUp(Grammar grammar) throws IOException {
        super.setUp(grammar);
        List<String> oovPOS = this.settings.getStringList("oovPOS");
        if (oovPOS.isEmpty()) {
            oovPOS = this.settings.getStringList("pos");
        }
        POS stringPos = new POS(oovPOS);
        String userPosMode = this.settings.getString("userPOS", "forbid");
        this.posId = this.posIdOf(grammar, stringPos, userPosMode);
        if (this.posId == -1) {
            throw new IllegalArgumentException("POS " + stringPos + " was not present in the dictionary");
        }
        this.cost = RegexOovProvider.checkedShort(this.settings, "cost");
        this.leftId = RegexOovProvider.checkedShort(this.settings, "leftId");
        this.rightId = RegexOovProvider.checkedShort(this.settings, "rightId");
        this.pattern = RegexOovProvider.checkPattern(this.settings.getString("regex"));
        this.maxLength = this.settings.getInt("maxLength", 32);
        this.strictBoundaries = RegexOovProvider.isStrictContinuity(this.settings);
    }

    @Override
    public int provideOOV(InputText inputText, int offset, long otherWords, List<LatticeNodeImpl> nodes) {
        int previousContinuity;
        int currentContinuity;
        if (this.strictBoundaries && offset > 0 && (currentContinuity = inputText.getCharCategoryContinuousLength(offset)) + 1 == (previousContinuity = inputText.getCharCategoryContinuousLength(offset - 1))) {
            return 0;
        }
        String text = inputText.getText();
        Matcher matcher = this.pattern.matcher(text);
        byte[] byteText = inputText.getByteText();
        int textLength = byteText.length;
        int regionStartChars = inputText.modifiedOffset(offset);
        int regionEndBytes = Math.min(offset + this.maxLength, textLength);
        int regionEndChars = inputText.modifiedOffset(regionEndBytes);
        matcher.region(regionStartChars, regionEndChars);
        if (matcher.find()) {
            int endChar = matcher.end();
            int oovLength = inputText.getCodePointsOffsetLength(offset, endChar - regionStartChars);
            if (WordMask.hasNth(otherWords, oovLength)) {
                if (oovLength > 63) {
                    int byteEnd = offset + oovLength;
                    for (LatticeNodeImpl node : nodes) {
                        if (node.end != byteEnd) continue;
                        return 0;
                    }
                } else {
                    return 0;
                }
            }
            LatticeNodeImpl node = new LatticeNodeImpl(null, this.leftId, this.rightId, this.cost, -1);
            node.setOOV();
            String oov = text.substring(matcher.start(), matcher.end());
            WordInfo info = new WordInfo(oov, (short)oovLength, this.posId, oov, oov, "");
            node.setWordInfo(info);
            nodes.add(node);
            return 1;
        }
        return 0;
    }

    private static short checkedShort(Settings settings, String name) {
        int value = settings.getInt(name);
        if (value > Short.MAX_VALUE) {
            throw new IllegalArgumentException("The value of parameter " + name + " was larger than " + Short.MAX_VALUE);
        }
        return (short)value;
    }

    private static Pattern checkPattern(String regex) {
        if (!regex.startsWith("^")) {
            regex = "^" + regex;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher x = pattern.matcher("does not matter");
        x.reset();
        return pattern;
    }

    private static boolean isStrictContinuity(Settings settings) {
        String content = settings.getString("boundaries", "strict");
        if ("strict".equalsIgnoreCase(content)) {
            return true;
        }
        if ("relaxed".equalsIgnoreCase(content)) {
            return false;
        }
        throw new IllegalArgumentException("allowed continuity values: [strict, relaxed], was " + content);
    }
}

