/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputText;
import com.worksap.nlp.sudachi.LatticeNodeImpl;
import com.worksap.nlp.sudachi.OovProviderPlugin;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import com.worksap.nlp.sudachi.dictionary.POS;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import java.util.List;

class SimpleOovProviderPlugin
extends OovProviderPlugin {
    short oovPOSId;
    short leftId;
    short rightId;
    short cost;

    SimpleOovProviderPlugin() {
    }

    @Override
    public void setUp(Grammar grammar) {
        POS pos = new POS(this.settings.getStringList("oovPOS"));
        this.leftId = (short)this.settings.getInt("leftId");
        this.rightId = (short)this.settings.getInt("rightId");
        this.cost = (short)this.settings.getInt("cost");
        String userPosMode = this.settings.getString("userPOS", "forbid");
        this.oovPOSId = this.posIdOf(grammar, pos, userPosMode);
    }

    @Override
    public int provideOOV(InputText inputText, int offset, long otherWords, List<LatticeNodeImpl> nodes) {
        if (otherWords == 0L) {
            LatticeNodeImpl node = this.createNode();
            node.setParameter(this.leftId, this.rightId, this.cost);
            int length = inputText.getWordCandidateLength(offset);
            String s = inputText.getSubstring(offset, offset + length);
            WordInfo info = new WordInfo(s, (short)length, this.oovPOSId, s, s, "");
            node.setWordInfo(info);
            nodes.add(node);
            return 1;
        }
        return 0;
    }
}

