/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.Config;
import com.worksap.nlp.sudachi.dictionary.CategoryType;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;

public class CharacterCategory {
    private static final Pattern PATTERN_SPACES = Pattern.compile("\\s+");
    private static final Pattern PATTERN_EMPTY_OR_SPACES = Pattern.compile("\\s*");
    private static final Pattern PATTERN_DOUBLE_PERIODS = Pattern.compile("\\.\\.");
    private final List<Range> rangeList = new ArrayList<Range>();

    public EnumSet<CategoryType> getCategoryTypes(int codePoint) {
        EnumSet<CategoryType> categories = EnumSet.noneOf(CategoryType.class);
        for (Range range : this.rangeList) {
            if (!range.contains(codePoint)) continue;
            categories.addAll(range.categories);
        }
        if (categories.isEmpty()) {
            categories.add(CategoryType.DEFAULT);
        }
        return categories;
    }

    @Deprecated
    public void readCharacterDefinition(String charDef) throws IOException {
        try (InputStream in = charDef != null ? new FileInputStream(charDef) : CharacterCategory.class.getClassLoader().getResourceAsStream("char.def");){
            this.readCharacterDefinition(in);
        }
    }

    public void readCharacterDefinition(InputStream in) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || PATTERN_EMPTY_OR_SPACES.matcher(line).matches()) continue;
            String[] cols = PATTERN_SPACES.split(line);
            if (cols.length < 2) {
                throw new IllegalArgumentException("invalid format at line " + reader.getLineNumber());
            }
            if (!cols[0].startsWith("0x")) continue;
            Range range = new Range();
            String[] r = PATTERN_DOUBLE_PERIODS.split(cols[0]);
            range.low = range.high = Integer.decode(r[0]).intValue();
            if (r.length > 1) {
                range.high = Integer.decode(r[1]);
            }
            if (range.low > range.high) {
                throw new IllegalArgumentException("invalid range at line " + reader.getLineNumber());
            }
            for (int i = 1; i < cols.length && !cols[i].startsWith("#"); ++i) {
                CategoryType type;
                try {
                    type = CategoryType.valueOf(cols[i]);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(cols[i] + " is invalid type at line " + reader.getLineNumber(), e);
                }
                range.categories.add(type);
            }
            this.rangeList.add(range);
        }
    }

    public static CharacterCategory load(Config.Resource<CharacterCategory> resource) throws IOException {
        return resource.consume(res -> {
            CharacterCategory result = new CharacterCategory();
            try (InputStream is = res.asInputStream();){
                result.readCharacterDefinition(is);
            }
            return result;
        });
    }

    static class Range {
        int low;
        int high;
        EnumSet<CategoryType> categories = EnumSet.noneOf(CategoryType.class);

        Range() {
        }

        boolean contains(int cp) {
            return cp >= this.low && cp <= this.high;
        }

        int containingLength(String text) {
            int i = 0;
            while (i < text.length()) {
                int c = text.codePointAt(i);
                if (c < this.low || c > this.high) {
                    return i;
                }
                i = text.offsetByCodePoints(i, 1);
            }
            return text.length();
        }
    }
}

