/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import java.nio.ShortBuffer;

public final class Connection {
    private final ShortBuffer matrix;
    private final int leftSize;
    private final int rightSize;

    public Connection(ShortBuffer matrix, int leftSize, int rightSize) {
        this.matrix = matrix;
        this.leftSize = leftSize;
        this.rightSize = rightSize;
    }

    private int ix(int left, int right) {
        assert (left < this.leftSize);
        assert (right < this.rightSize);
        return right * this.leftSize + left;
    }

    public short cost(int left, int right) {
        return this.matrix.get(this.ix(left, right));
    }

    public int getLeftSize() {
        return this.leftSize;
    }

    public int getRightSize() {
        return this.rightSize;
    }

    public void setCost(int left, int right, short cost) {
        this.matrix.put(this.ix(left, right), cost);
    }

    public Connection ownedCopy() {
        ShortBuffer copy = ShortBuffer.allocate(this.matrix.limit());
        copy.put(this.matrix);
        return new Connection(copy, this.leftSize, this.rightSize);
    }

    public void validate(int leftId) {
        if (this.matrix == null) {
            throw new NullPointerException("matrix");
        }
        if (leftId >= this.leftSize) {
            throw new IllegalArgumentException(String.format("leftId < leftSize: (%d, %d)", leftId, this.leftSize));
        }
    }
}

