/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.dictionary.build.DicBuilder;
import com.worksap.nlp.sudachi.dictionary.build.Progress;
import java.io.Console;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;

public class DictionaryBuilder {
    private DictionaryBuilder() {
    }

    static void printUsage() {
        Console console = System.console();
        console.printf("usage: DictionaryBuilder -o file -m file [-d description] files...\n", new Object[0]);
        console.printf("\t-o file\toutput to file\n", new Object[0]);
        console.printf("\t-m file\tmatrix file\n", new Object[0]);
        console.printf("\t-d description\tcomment\n", new Object[0]);
    }

    public static void main(String[] args) throws IOException {
        int i;
        String description = "";
        String outputPath = null;
        String matrixPath = null;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-o") && i + 1 < args.length) {
                outputPath = args[++i];
                continue;
            }
            if (args[i].equals("-m") && i + 1 < args.length) {
                matrixPath = args[++i];
                continue;
            }
            if (args[i].equals("-d") && i + 1 < args.length) {
                description = args[++i];
                continue;
            }
            if (!args[i].equals("-h")) break;
            DictionaryBuilder.printUsage();
            return;
        }
        if (args.length <= i || outputPath == null || matrixPath == null) {
            DictionaryBuilder.printUsage();
            return;
        }
        List<String> lexiconPaths = Arrays.asList(args).subList(i, args.length);
        DicBuilder.System builder = (DicBuilder.System)((DicBuilder.System)DicBuilder.system().matrix(Paths.get(matrixPath, new String[0])).description(description)).progress(new Progress(20, new StderrProgress()));
        for (String lexiconPath : lexiconPaths) {
            builder = (DicBuilder.System)builder.lexicon(Paths.get(lexiconPath, new String[0]));
        }
        try (SeekableByteChannel ch = Files.newByteChannel(Paths.get(outputPath, new String[0]), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            builder.build(ch);
        }
    }

    public static class StderrProgress
    implements Progress.Callback {
        float last = 0.0f;
        String unit = "bytes";
        static final double NANOS_PER_SECOND = 1.0E9;

        @Override
        public void start(String name, Progress.Kind kind) {
            System.err.printf("%s\t", name);
            this.last = 0.0f;
            switch (kind) {
                case OUTPUT: {
                    this.unit = "bytes";
                    break;
                }
                case INPUT: {
                    this.unit = "entries";
                }
            }
        }

        @Override
        public void progress(float progress) {
            while (this.last < progress) {
                this.last += 0.05f;
                System.err.print(".");
            }
        }

        @Override
        public void end(long size, Duration time) {
            double seconds = (double)time.getSeconds() + (double)time.getNano() / 1.0E9;
            System.err.printf("\tDone! (%d %s, %.3f sec)%n", size, this.unit, seconds);
        }
    }
}

