/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.dictionary.CharacterCategory;
import com.worksap.nlp.sudachi.dictionary.Connection;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import com.worksap.nlp.sudachi.dictionary.POS;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GrammarImpl
implements Grammar {
    private static final int POS_DEPTH = 6;
    private static final short[] BOS_PARAMETER = new short[]{0, 0, 0};
    private static final short[] EOS_PARAMETER = new short[]{0, 0, 0};
    private final ByteBuffer bytes;
    private final List<POS> posList;
    private final short originalPosSize;
    private boolean isCopiedConnectTable;
    private Connection matrix;
    private CharacterCategory charCategory;
    private int storageSize;

    public GrammarImpl(ByteBuffer bytes, int offset) {
        int originalOffset = offset;
        this.bytes = bytes;
        this.isCopiedConnectTable = false;
        int posSize = bytes.getShort(offset);
        offset += 2;
        this.posList = new ArrayList<POS>(posSize);
        for (int i = 0; i < posSize; ++i) {
            String[] pos = new String[6];
            for (int j = 0; j < 6; ++j) {
                pos[j] = this.bufferToString(offset);
                offset += 1 + 2 * pos[j].length();
            }
            this.posList.add(new POS(pos));
        }
        this.originalPosSize = (short)this.posList.size();
        short leftIdSize = bytes.getShort(offset);
        short rightIdSize = bytes.getShort(offset += 2);
        ByteBuffer dup = bytes.duplicate();
        dup.position(offset += 2);
        dup.order(bytes.order());
        dup.limit(offset + leftIdSize * rightIdSize * 2);
        this.matrix = new Connection(dup.asShortBuffer(), leftIdSize, rightIdSize);
        this.storageSize = offset - originalOffset + 2 * leftIdSize * rightIdSize;
    }

    public GrammarImpl() {
        this.bytes = ByteBuffer.allocate(0);
        this.posList = Collections.emptyList();
        this.originalPosSize = 0;
    }

    public int storageSize() {
        return this.storageSize;
    }

    public void addPosList(GrammarImpl grammar) {
        this.posList.addAll(grammar.posList);
    }

    @Override
    public int getPartOfSpeechSize() {
        return this.posList.size();
    }

    public short getSystemPartOfSpeechSize() {
        return this.originalPosSize;
    }

    @Override
    public POS getPartOfSpeechString(short posId) {
        return this.posList.get(posId);
    }

    @Override
    public short getPartOfSpeechId(List<String> pos) {
        return (short)this.posList.indexOf(pos);
    }

    @Override
    public short getConnectCost(short left, short right) {
        return this.matrix.cost(left, right);
    }

    @Override
    public void setConnectCost(short left, short right, short cost) {
        if (!this.isCopiedConnectTable) {
            this.matrix = this.matrix.ownedCopy();
            this.isCopiedConnectTable = true;
        }
        this.matrix.setCost(left, right, cost);
    }

    @Override
    public short[] getBOSParameter() {
        return BOS_PARAMETER;
    }

    @Override
    public short[] getEOSParameter() {
        return EOS_PARAMETER;
    }

    @Override
    public CharacterCategory getCharacterCategory() {
        return this.charCategory;
    }

    @Override
    public void setCharacterCategory(CharacterCategory charCategory) {
        this.charCategory = charCategory;
    }

    private String bufferToString(int offset) {
        int length = Byte.toUnsignedInt(this.bytes.get(offset++));
        char[] str = new char[length];
        for (int i = 0; i < length; ++i) {
            str[i] = this.bytes.getChar(offset + 2 * i);
        }
        return new String(str);
    }

    @Override
    public Connection getConnection() {
        return this.matrix;
    }

    public short registerPOS(POS pos) {
        int i = this.posList.indexOf(pos);
        if (i == -1) {
            int len = this.posList.size();
            this.posList.add(pos);
            return (short)len;
        }
        return (short)i;
    }
}

