/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;

public final class POS
extends AbstractList<String> {
    public static final int DEPTH = 6;
    public static final int MAX_COMPONENT_LENGTH = 127;
    private final String[] elems;

    public POS(String ... elems) {
        if (elems == null) {
            throw new IllegalArgumentException("pos must not be null");
        }
        if (elems.length != 6) {
            throw new IllegalArgumentException(String.format("pos must have exactly 6 elements, was %s: %s", elems.length, String.join((CharSequence)",", elems)));
        }
        for (String e : elems) {
            if (e == null) {
                throw new IllegalArgumentException("POS components can't be null");
            }
            if (e.length() <= 127) continue;
            throw new IllegalArgumentException(String.format("POS component had length (%d) > %d: %s", e.length(), 127, e));
        }
        this.elems = elems;
    }

    public POS(List<String> elems) {
        this(elems.toArray(new String[0]));
    }

    @Override
    public String get(int i) {
        return this.elems[i];
    }

    @Override
    public int size() {
        return 6;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof POS) {
            POS strings = (POS)o;
            return Arrays.equals(this.elems, strings.elems);
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int result = 65261;
        result = 31 * result + Arrays.hashCode(this.elems);
        return result;
    }

    @Override
    public String toString() {
        return String.join((CharSequence)",", this.elems);
    }
}

