/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.dictionary.DoubleArrayLexicon;
import com.worksap.nlp.sudachi.dictionary.DoubleArrayLookup;
import com.worksap.nlp.sudachi.dictionary.WordIdTable;
import java.util.Arrays;
import java.util.List;

public final class WordLookup {
    private final DoubleArrayLookup lookup = new DoubleArrayLookup();
    private WordIdTable words;
    private int[] wordIds = new int[16];
    private int numWords;
    private final List<DoubleArrayLexicon> lexicons;
    private int currentLexicon = -1;

    public WordLookup(List<DoubleArrayLexicon> lexicons) {
        this.lexicons = lexicons;
    }

    private void rebind(DoubleArrayLexicon lexicon) {
        this.lookup.setArray(lexicon.getTrieArray());
        this.words = lexicon.getWordIdTable();
    }

    public void reset(byte[] key, int offset, int limit) {
        this.currentLexicon = this.lexicons.size() - 1;
        this.rebind(this.lexicons.get(this.currentLexicon));
        this.lookup.reset(key, offset, limit);
    }

    public int[] outputBuffer(int length) {
        if (this.wordIds.length < length) {
            this.wordIds = Arrays.copyOf(this.wordIds, Math.max(length, this.wordIds.length * 2));
        }
        return this.wordIds;
    }

    public boolean next() {
        while (!this.lookup.next()) {
            int nextLexicon = this.currentLexicon - 1;
            if (nextLexicon < 0) {
                return false;
            }
            this.rebind(this.lexicons.get(nextLexicon));
            this.currentLexicon = nextLexicon;
        }
        int wordGroupId = this.lookup.getValue();
        this.numWords = this.words.readWordIds(wordGroupId, this);
        return true;
    }

    public int getEndOffset() {
        return this.lookup.getOffset();
    }

    public int getNumWords() {
        return this.numWords;
    }

    public int[] getWordsIds() {
        return this.wordIds;
    }
}

