/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary.build;

import com.worksap.nlp.sudachi.dictionary.Connection;
import com.worksap.nlp.sudachi.dictionary.build.InputFileException;
import com.worksap.nlp.sudachi.dictionary.build.ModelOutput;
import com.worksap.nlp.sudachi.dictionary.build.WriteDictionary;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;

public class ConnectionMatrix
implements WriteDictionary {
    private short numLeft;
    private short numRight;
    private ByteBuffer compiled;
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern OPT_WHITESPACE = Pattern.compile("\\s*");

    public ByteBuffer getCompiled() {
        return this.compiled;
    }

    public ByteBuffer getCompiledNoHeader() {
        ByteBuffer b = this.compiled;
        int pos = b.position();
        int lim = b.limit();
        b.position(4);
        b.limit(b.capacity());
        ByteBuffer slice = b.slice();
        slice.order(b.order());
        b.position(pos);
        b.limit(lim);
        return slice;
    }

    public long readEntries(InputStream data) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(data, StandardCharsets.UTF_8));
        String header = reader.readLine();
        if (header == null) {
            throw new IllegalArgumentException("invalid format at line " + reader.getLineNumber());
        }
        String[] lr = WHITESPACE.split(header, 2);
        if (lr.length != 2) {
            throw new IllegalArgumentException("invalid header " + header + ", expected two 16-bit integers");
        }
        try {
            this.numLeft = Short.parseShort(lr[0]);
            this.numRight = Short.parseShort(lr[1]);
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException("invalid header " + header + ", expected two 16-bit integers");
        }
        ByteBuffer buffer = ByteBuffer.allocate(2 * this.numLeft * this.numRight + 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer matrix = buffer.asShortBuffer();
        matrix.put(this.numLeft);
        matrix.put(this.numRight);
        matrix = matrix.slice();
        Connection conn = new Connection(matrix, this.numLeft, this.numRight);
        long numLines = 0L;
        while ((line = reader.readLine()) != null) {
            if (OPT_WHITESPACE.matcher(line).matches()) continue;
            String[] cols = WHITESPACE.split(line);
            if (cols.length < 3) {
                throw new InputFileException(reader.getLineNumber(), line, new IllegalArgumentException("not enough entries"));
            }
            try {
                short left = Short.parseShort(cols[0]);
                short right = Short.parseShort(cols[1]);
                short cost = Short.parseShort(cols[2]);
                conn.setCost(left, right, cost);
            }
            catch (NumberFormatException e) {
                throw new InputFileException(reader.getLineNumber(), "", e);
            }
            ++numLines;
        }
        buffer.position(0);
        this.compiled = buffer;
        return numLines;
    }

    public void makeEmpty() {
        ByteBuffer data = ByteBuffer.allocate(4);
        data.order(ByteOrder.LITTLE_ENDIAN);
        data.putShort((short)0);
        data.putShort((short)0);
        data.flip();
        this.compiled = data;
    }

    @Override
    public void writeTo(ModelOutput output) throws IOException {
        output.write(this.compiled);
    }

    public short getNumLeft() {
        return this.numLeft;
    }

    public short getNumRight() {
        return this.numRight;
    }
}

