/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary.build;

import com.worksap.nlp.sudachi.dictionary.CSVParser;
import com.worksap.nlp.sudachi.dictionary.Connection;
import com.worksap.nlp.sudachi.dictionary.DictionaryAccess;
import com.worksap.nlp.sudachi.dictionary.DictionaryHeader;
import com.worksap.nlp.sudachi.dictionary.build.BuildStats;
import com.worksap.nlp.sudachi.dictionary.build.ConnectionMatrix;
import com.worksap.nlp.sudachi.dictionary.build.CsvLexicon;
import com.worksap.nlp.sudachi.dictionary.build.Index;
import com.worksap.nlp.sudachi.dictionary.build.InputFileException;
import com.worksap.nlp.sudachi.dictionary.build.ModelOutput;
import com.worksap.nlp.sudachi.dictionary.build.POSTable;
import com.worksap.nlp.sudachi.dictionary.build.Progress;
import com.worksap.nlp.sudachi.dictionary.build.TrackingInputStream;
import com.worksap.nlp.sudachi.dictionary.build.WordIdResolver;
import com.worksap.nlp.sudachi.dictionary.build.WordLookup;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class DicBuilder {
    private DicBuilder() {
    }

    public static SystemNoMatrix system() {
        return new SystemNoMatrix(new System());
    }

    public static User user(DictionaryAccess system) {
        return new User(system);
    }

    public static final class SystemNoMatrix {
        private final System inner;

        private SystemNoMatrix(System inner) {
            this.inner = inner;
        }

        public System matrix(InputStream data) throws IOException {
            this.inner.readMatrix(data);
            return this.inner;
        }

        public System matrix(URL data) throws IOException {
            try (InputStream is = data.openStream();){
                System system = this.matrix(is);
                return system;
            }
        }

        public System matrix(Path path) throws IOException {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                System system = this.matrix(is);
                return system;
            }
        }
    }

    public static final class User
    extends Base<User> {
        final DictionaryAccess dictionary;

        private User(DictionaryAccess dictionary) {
            this.dictionary = dictionary;
            this.version = -3848306685500829776L;
            Connection conn = dictionary.getGrammar().getConnection();
            this.lexicon.setLimits(conn.getLeftSize(), conn.getRightSize());
            this.connection.makeEmpty();
            this.pos.preloadFrom(dictionary.getGrammar());
        }

        @Override
        protected WordIdResolver resolver() {
            return new WordLookup.Chain(new WordLookup.Prebuilt(this.dictionary.getLexicon()), new WordLookup.Csv(this.lexicon));
        }
    }

    public static final class System
    extends Base<System> {
        public System() {
            this.version = -3558123966965398476L;
        }

        private void readMatrix(InputStream matrix) throws IOException {
            this.connection.readEntries(matrix);
            this.lexicon.setLimits(this.connection.getNumLeft(), this.connection.getNumRight());
        }
    }

    public static abstract class Base<T extends Base<T>> {
        protected final POSTable pos = new POSTable();
        protected final ConnectionMatrix connection = new ConnectionMatrix();
        protected final Index index = new Index();
        protected String description = "";
        protected long version;
        protected long creationTime = java.lang.System.currentTimeMillis();
        private final List<ModelOutput.Part> inputs = new ArrayList<ModelOutput.Part>();
        private Progress progress;
        protected final CsvLexicon lexicon = new CsvLexicon(this.pos);

        protected WordIdResolver resolver() {
            return new WordLookup.Csv(this.lexicon);
        }

        private T self() {
            return (T)this;
        }

        public BuildStats build(SeekableByteChannel result) throws IOException {
            this.lexicon.setResolver(this.resolver());
            ModelOutput output = new ModelOutput(result);
            if (this.progress != null) {
                output.progressor(this.progress);
            }
            DictionaryHeader header = new DictionaryHeader(this.version, this.creationTime, this.description);
            ByteBuffer headerBuffer = ByteBuffer.wrap(header.toByte());
            output.write(headerBuffer);
            this.pos.writeTo(output);
            this.connection.writeTo(output);
            this.index.writeTo(output);
            this.lexicon.writeTo(output);
            return new BuildStats(this.inputs, output.getParts());
        }

        public T lexicon(URL data) throws IOException {
            URLConnection conn = data.openConnection();
            try (InputStream is = conn.getInputStream();){
                long length = data.openConnection().getContentLengthLong();
                T t = this.lexiconImpl(data.getPath(), is, length);
                return t;
            }
        }

        public T lexicon(Path path) throws IOException {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                T t = this.lexiconImpl(path.getFileName().toString(), is, Files.size(path));
                return t;
            }
        }

        public T lexicon(InputStream data) throws IOException {
            return this.lexiconImpl("<input stream>", data, data.available());
        }

        public T lexiconImpl(String name, InputStream data, long size) throws IOException {
            List<String> fields;
            long startTime = java.lang.System.nanoTime();
            if (this.progress != null) {
                this.progress.startBlock(name, startTime, Progress.Kind.INPUT);
            }
            TrackingInputStream tracker = new TrackingInputStream(data);
            CSVParser parser = new CSVParser(new InputStreamReader((InputStream)tracker, StandardCharsets.UTF_8));
            int line = 1;
            while ((fields = parser.getNextRecord()) != null) {
                try {
                    CsvLexicon.WordEntry e = this.lexicon.parseLine(fields);
                    int wordId = this.lexicon.addEntry(e);
                    if (e.headword != null) {
                        this.index.add(e.headword, wordId);
                    }
                    ++line;
                }
                catch (Exception e) {
                    throw new InputFileException(line, fields.get(0), e);
                }
                if (this.progress == null) continue;
                this.progress.progress(tracker.getPosition(), size);
            }
            long time = java.lang.System.nanoTime() - startTime;
            if (this.progress != null) {
                this.progress.endBlock(line, time);
            }
            this.inputs.add(new ModelOutput.Part(name, time, line));
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T progress(Progress progress) {
            this.progress = progress;
            return this.self();
        }
    }
}

