/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary.build;

import com.worksap.nlp.dartsclone.DoubleArray;
import com.worksap.nlp.sudachi.dictionary.build.DicBuffer;
import com.worksap.nlp.sudachi.dictionary.build.ModelOutput;
import com.worksap.nlp.sudachi.dictionary.build.WriteDictionary;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class Index
implements WriteDictionary {
    private final SortedMap<byte[], List<Integer>> elements = new TreeMap<byte[], List<Integer>>((l, r) -> {
        int llen = ((byte[])l).length;
        int rlen = ((byte[])r).length;
        for (int i = 0; i < Math.min(llen, rlen); ++i) {
            if (l[i] == r[i]) continue;
            return (l[i] & 0xFF) - (r[i] & 0xFF);
        }
        return ((byte[])l).length - ((byte[])r).length;
    });
    private int count = 0;

    public int add(String key, int wordId) {
        byte[] bytes = key.getBytes(StandardCharsets.UTF_8);
        List entries = this.elements.computeIfAbsent(bytes, k -> new ArrayList());
        if (entries.size() >= 255) {
            throw new IllegalArgumentException(String.format("key %s has >= 255 entries in the dictionary", key));
        }
        entries.add(wordId);
        ++this.count;
        return bytes.length;
    }

    @Override
    public void writeTo(ModelOutput output) throws IOException {
        DoubleArray trie = new DoubleArray();
        int size = this.elements.size();
        byte[][] keys = new byte[size][];
        int[] values = new int[size];
        ByteBuffer wordIdTable = ByteBuffer.allocate(this.count * 6);
        wordIdTable.order(ByteOrder.LITTLE_ENDIAN);
        output.withSizedPart("WordId table", () -> {
            int i = 0;
            int numEntries = this.elements.entrySet().size();
            for (Map.Entry<byte[], List<Integer>> entry : this.elements.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = wordIdTable.position();
                ++i;
                List<Integer> wordIds = entry.getValue();
                wordIdTable.put((byte)wordIds.size());
                for (int wid : wordIds) {
                    wordIdTable.putInt(wid);
                }
                output.progress(i, numEntries);
            }
            return wordIdTable.position() + 4;
        });
        DicBuffer buffer = new DicBuffer(4);
        output.withPart("double array Trie", () -> {
            trie.build(keys, values, output::progress);
            buffer.putInt(trie.size());
            buffer.consume(output::write);
            output.write(trie.byteArray());
        });
        buffer.putInt(wordIdTable.position());
        buffer.consume(output::write);
        wordIdTable.flip();
        output.write(wordIdTable);
    }
}

