/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary.build;

import java.time.Duration;

public class Progress {
    private static final long MS_100 = 100000000L;
    private final int maxUpdates;
    private final Callback callback;
    private float currentProgress;
    private long lastUpdate;

    public Progress(int maxUpdates, Callback callback) {
        this.maxUpdates = maxUpdates;
        this.callback = callback;
    }

    public void startBlock(String name, long start, Kind kind) {
        this.lastUpdate = start;
        this.callback.start(name, kind);
        this.currentProgress = this.step();
    }

    private float step() {
        return 1.0f / (float)this.maxUpdates - 1.0E-6f;
    }

    public void progress(long cur, long max) {
        double ratio = (double)cur / (double)max;
        if (ratio > (double)this.currentProgress) {
            long curTime;
            if (ratio >= 1.0) {
                this.callback.progress(1.0f);
                this.currentProgress = Float.MAX_VALUE;
            }
            if ((curTime = System.nanoTime()) - this.lastUpdate > 100000000L) {
                this.callback.progress((float)ratio);
                float step = this.step();
                double nsteps = ratio / (double)step;
                this.currentProgress = (float)((double)this.currentProgress + Math.floor(nsteps) * (double)step);
                assert (ratio < (double)this.currentProgress);
                this.lastUpdate = curTime;
            }
        }
    }

    public void endBlock(long size, long time) {
        this.callback.end(size, Duration.ofNanos(time));
    }

    public static interface Callback {
        default public void start(String name, Kind kind) {
        }

        public void progress(float var1);

        default public void end(long size, Duration time) {
        }
    }

    public static enum Kind {
        INPUT,
        OUTPUT;

    }
}

