/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary.build;

import com.worksap.nlp.sudachi.WordId;
import com.worksap.nlp.sudachi.dictionary.Lexicon;
import com.worksap.nlp.sudachi.dictionary.build.CsvLexicon;
import com.worksap.nlp.sudachi.dictionary.build.WordIdResolver;
import java.util.List;

public class WordLookup {
    private WordLookup() {
    }

    public static class Chain
    implements WordIdResolver {
        private final WordIdResolver system;
        private final WordIdResolver user;

        public Chain(WordIdResolver system, WordIdResolver user) {
            this.system = system;
            this.user = user;
        }

        @Override
        public int lookup(String headword, short posId, String reading) {
            int wid = this.user.lookup(headword, posId, reading);
            if (wid == -1) {
                return this.system.lookup(headword, posId, reading);
            }
            return WordId.make(1, wid);
        }

        @Override
        public void validate(int wordId) {
            int dic = WordId.dic(wordId);
            if (dic == 0) {
                this.system.validate(wordId);
            } else if (dic == 1) {
                this.user.validate(WordId.word(wordId));
            } else {
                throw new IllegalArgumentException("dictionary id can be only 0 or 1 at the build time");
            }
        }

        @Override
        public boolean isUser() {
            return true;
        }
    }

    public static class Prebuilt
    implements WordIdResolver {
        private final Lexicon lexicon;
        private final int prebuiltSize;

        public Prebuilt(Lexicon lexicon) {
            this.lexicon = lexicon;
            this.prebuiltSize = lexicon.size();
        }

        @Override
        public int lookup(String headword, short posId, String reading) {
            return this.lexicon.getWordId(headword, posId, reading);
        }

        @Override
        public void validate(int wordId) {
            int word = WordId.word(wordId);
            if (word > this.prebuiltSize) {
                throw new IllegalArgumentException("WordId was larger than the number of dictionary entries");
            }
        }

        @Override
        public boolean isUser() {
            return false;
        }
    }

    public static class Csv
    implements WordIdResolver {
        private final CsvLexicon lexicon;

        public Csv(CsvLexicon lexicon) {
            this.lexicon = lexicon;
        }

        @Override
        public int lookup(String headword, short posId, String reading) {
            List<CsvLexicon.WordEntry> entries = this.lexicon.getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                CsvLexicon.WordEntry entry = entries.get(i);
                if (!entry.wordInfo.getSurface().equals(headword) || entry.wordInfo.getPOSId() != posId || !entry.wordInfo.getReadingForm().equals(reading)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void validate(int wordId) {
            if (wordId < 0) {
                throw new IllegalArgumentException("wordId can't be negative, was " + wordId);
            }
            List<CsvLexicon.WordEntry> entries = this.lexicon.getEntries();
            if (wordId >= entries.size()) {
                throw new IllegalArgumentException(String.format("wordId %d was larger than number of dictionary entries (%d)", wordId, entries.size()));
            }
        }

        @Override
        public boolean isUser() {
            return false;
        }
    }

    public static class Noop
    implements WordIdResolver {
        @Override
        public int lookup(String headword, short posId, String reading) {
            return -1;
        }

        @Override
        public void validate(int wordId) {
        }

        @Override
        public boolean isUser() {
            return false;
        }
    }
}

