/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java;

import com.worldline.connect.sdk.java.ApiResource;
import com.worldline.connect.sdk.java.Communicator;
import com.worldline.connect.sdk.java.logging.BodyObfuscator;
import com.worldline.connect.sdk.java.logging.CommunicatorLogger;
import com.worldline.connect.sdk.java.logging.HeaderObfuscator;
import com.worldline.connect.sdk.java.logging.LoggingCapable;
import com.worldline.connect.sdk.java.logging.ObfuscationCapable;
import com.worldline.connect.sdk.java.v1.V1Client;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;

public class Client
extends ApiResource
implements Closeable,
LoggingCapable,
ObfuscationCapable {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public Client(Communicator communicator) {
        this(communicator, null);
    }

    private Client(Communicator communicator, String clientMetaInfo) {
        super(communicator, clientMetaInfo, null);
    }

    public Client withClientMetaInfo(String clientMetaInfo) {
        if (this.clientMetaInfo == null && clientMetaInfo == null) {
            return this;
        }
        if (clientMetaInfo == null) {
            return new Client(this.communicator, null);
        }
        this.communicator.getMarshaller().unmarshal(clientMetaInfo, Object.class);
        clientMetaInfo = Base64.getEncoder().encodeToString(clientMetaInfo.getBytes(CHARSET));
        return clientMetaInfo.equals(this.clientMetaInfo) ? this : new Client(this.communicator, clientMetaInfo);
    }

    public void closeIdleConnections(long idleTime, TimeUnit timeUnit) {
        this.communicator.closeIdleConnections(idleTime, timeUnit);
    }

    public void closeExpiredConnections() {
        this.communicator.closeExpiredConnections();
    }

    @Override
    public void setBodyObfuscator(BodyObfuscator bodyObfuscator) {
        this.communicator.setBodyObfuscator(bodyObfuscator);
    }

    @Override
    public void setHeaderObfuscator(HeaderObfuscator headerObfuscator) {
        this.communicator.setHeaderObfuscator(headerObfuscator);
    }

    @Override
    public void enableLogging(CommunicatorLogger communicatorLogger) {
        this.communicator.enableLogging(communicatorLogger);
    }

    @Override
    public void disableLogging() {
        this.communicator.disableLogging();
    }

    @Override
    public void close() throws IOException {
        this.communicator.close();
    }

    public V1Client v1() {
        return new V1Client(this, null);
    }
}

