/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java;

import com.worldline.connect.sdk.java.BodyHandler;
import com.worldline.connect.sdk.java.BodyHandlerException;
import com.worldline.connect.sdk.java.CallContext;
import com.worldline.connect.sdk.java.authentication.Authenticator;
import com.worldline.connect.sdk.java.communication.CommunicationException;
import com.worldline.connect.sdk.java.communication.Connection;
import com.worldline.connect.sdk.java.communication.MetadataProvider;
import com.worldline.connect.sdk.java.communication.MultipartFormDataObject;
import com.worldline.connect.sdk.java.communication.MultipartFormDataRequest;
import com.worldline.connect.sdk.java.communication.NotFoundException;
import com.worldline.connect.sdk.java.communication.ParamRequest;
import com.worldline.connect.sdk.java.communication.PooledConnection;
import com.worldline.connect.sdk.java.communication.RequestHeader;
import com.worldline.connect.sdk.java.communication.RequestParam;
import com.worldline.connect.sdk.java.communication.ResponseException;
import com.worldline.connect.sdk.java.communication.ResponseHeader;
import com.worldline.connect.sdk.java.json.Marshaller;
import com.worldline.connect.sdk.java.logging.BodyObfuscator;
import com.worldline.connect.sdk.java.logging.CommunicatorLogger;
import com.worldline.connect.sdk.java.logging.HeaderObfuscator;
import com.worldline.connect.sdk.java.logging.LoggingCapable;
import com.worldline.connect.sdk.java.logging.ObfuscationCapable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.utils.URIBuilder;

public class Communicator
implements Closeable,
LoggingCapable,
ObfuscationCapable {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final URI apiEndpoint;
    private final Connection connection;
    private final Authenticator authenticator;
    private final MetadataProvider metadataProvider;
    private final Marshaller marshaller;

    public Communicator(URI apiEndpoint, Connection connection, Authenticator authenticator, MetadataProvider metadataProvider, Marshaller marshaller) {
        if (apiEndpoint == null) {
            throw new IllegalArgumentException("apiEndpoint is required");
        }
        if (apiEndpoint.getPath() != null && !apiEndpoint.getPath().isEmpty()) {
            throw new IllegalArgumentException("apiEndpoint should not contain a path");
        }
        if (apiEndpoint.getUserInfo() != null || apiEndpoint.getQuery() != null || apiEndpoint.getFragment() != null) {
            throw new IllegalArgumentException("apiEndpoint should not contain user info, query or fragment");
        }
        if (connection == null) {
            throw new IllegalArgumentException("connection is required");
        }
        if (authenticator == null) {
            throw new IllegalArgumentException("authenticator is required");
        }
        if (metadataProvider == null) {
            throw new IllegalArgumentException("metadataProvider is required");
        }
        if (marshaller == null) {
            throw new IllegalArgumentException("marshaller is required");
        }
        this.apiEndpoint = apiEndpoint;
        this.connection = connection;
        this.authenticator = authenticator;
        this.metadataProvider = metadataProvider;
        this.marshaller = marshaller;
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    public <O> O get(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, Class<O> responseType, CallContext context) {
        URI uri = this.toAbsoluteURI(relativePath, requestParameters);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        this.addGenericHeaders("GET", uri, requestHeaders, context);
        return (O)this.connection.get(uri, requestHeaders, (statusCode, bodyStream, headers) -> this.processResponse(statusCode, bodyStream, (List<ResponseHeader>)headers, responseType, relativePath, context));
    }

    public void get(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, BodyHandler bodyHandler, CallContext context) {
        URI uri = this.toAbsoluteURI(relativePath, requestParameters);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        this.addGenericHeaders("GET", uri, requestHeaders, context);
        this.connection.get(uri, requestHeaders, (statusCode, bodyStream, headers) -> {
            this.processResponse(statusCode, bodyStream, (List<ResponseHeader>)headers, bodyHandler, relativePath, context);
            return null;
        });
    }

    public <O> O delete(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, Class<O> responseType, CallContext context) {
        URI uri = this.toAbsoluteURI(relativePath, requestParameters);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        this.addGenericHeaders("DELETE", uri, requestHeaders, context);
        return (O)this.connection.delete(uri, requestHeaders, (statusCode, bodyStream, headers) -> this.processResponse(statusCode, bodyStream, (List<ResponseHeader>)headers, responseType, relativePath, context));
    }

    public void delete(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, BodyHandler bodyHandler, CallContext context) {
        URI uri = this.toAbsoluteURI(relativePath, requestParameters);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        this.addGenericHeaders("DELETE", uri, requestHeaders, context);
        this.connection.delete(uri, requestHeaders, (statusCode, bodyStream, headers) -> {
            this.processResponse(statusCode, bodyStream, (List<ResponseHeader>)headers, bodyHandler, relativePath, context);
            return null;
        });
    }

    public <O> O post(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, Object requestBody, Class<O> responseType, CallContext context) {
        if (requestBody instanceof MultipartFormDataObject) {
            return this.post(relativePath, requestHeaders, requestParameters, (MultipartFormDataObject)requestBody, responseType, context);
        }
        if (requestBody instanceof MultipartFormDataRequest) {
            MultipartFormDataObject multipart = ((MultipartFormDataRequest)requestBody).toMultipartFormDataObject();
            return this.post(relativePath, requestHeaders, requestParameters, multipart, responseType, context);
        }
        URI uri = this.toAbsoluteURI(relativePath, requestParameters);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        String requestJson = null;
        if (requestBody != null) {
            requestHeaders.add(new RequestHeader(CONTENT_TYPE_HEADER, CONTENT_TYPE_JSON));
            requestJson = this.marshaller.marshal(requestBody);
        }
        this.addGenericHeaders("POST", uri, requestHeaders, context);
        return (O)this.connection.post(uri, requestHeaders, requestJson, (statusCode, bodyStream, headers) -> this.processResponse(statusCode, bodyStream, (List<ResponseHeader>)headers, responseType, relativePath, context));
    }

    private <O> O post(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, MultipartFormDataObject multipart, Class<O> responseType, CallContext context) {
        URI uri = this.toAbsoluteURI(relativePath, requestParameters);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        requestHeaders.add(new RequestHeader(CONTENT_TYPE_HEADER, multipart.getContentType()));
        this.addGenericHeaders("POST", uri, requestHeaders, context);
        return (O)this.connection.post(uri, requestHeaders, multipart, (statusCode, bodyStream, headers) -> this.processResponse(statusCode, bodyStream, (List<ResponseHeader>)headers, responseType, relativePath, context));
    }

    public void post(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, Object requestBody, BodyHandler bodyHandler, CallContext context) {
        if (requestBody instanceof MultipartFormDataObject) {
            this.post(relativePath, requestHeaders, requestParameters, (MultipartFormDataObject)requestBody, bodyHandler, context);
            return;
        }
        if (requestBody instanceof MultipartFormDataRequest) {
            MultipartFormDataObject multipart = ((MultipartFormDataRequest)requestBody).toMultipartFormDataObject();
            this.post(relativePath, requestHeaders, requestParameters, multipart, bodyHandler, context);
            return;
        }
        URI uri = this.toAbsoluteURI(relativePath, requestParameters);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        String requestJson = null;
        if (requestBody != null) {
            requestHeaders.add(new RequestHeader(CONTENT_TYPE_HEADER, CONTENT_TYPE_JSON));
            requestJson = this.marshaller.marshal(requestBody);
        }
        this.addGenericHeaders("POST", uri, requestHeaders, context);
        this.connection.post(uri, requestHeaders, requestJson, (statusCode, bodyStream, headers) -> {
            this.processResponse(statusCode, bodyStream, (List<ResponseHeader>)headers, bodyHandler, relativePath, context);
            return null;
        });
    }

    private void post(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, MultipartFormDataObject multipart, BodyHandler bodyHandler, CallContext context) {
        URI uri = this.toAbsoluteURI(relativePath, requestParameters);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        requestHeaders.add(new RequestHeader(CONTENT_TYPE_HEADER, multipart.getContentType()));
        this.addGenericHeaders("POST", uri, requestHeaders, context);
        this.connection.post(uri, requestHeaders, multipart, (statusCode, bodyStream, headers) -> {
            this.processResponse(statusCode, bodyStream, (List<ResponseHeader>)headers, bodyHandler, relativePath, context);
            return null;
        });
    }

    public <O> O put(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, Object requestBody, Class<O> responseType, CallContext context) {
        if (requestBody instanceof MultipartFormDataObject) {
            return this.put(relativePath, requestHeaders, requestParameters, (MultipartFormDataObject)requestBody, responseType, context);
        }
        if (requestBody instanceof MultipartFormDataRequest) {
            MultipartFormDataObject multipart = ((MultipartFormDataRequest)requestBody).toMultipartFormDataObject();
            return this.put(relativePath, requestHeaders, requestParameters, multipart, responseType, context);
        }
        URI uri = this.toAbsoluteURI(relativePath, requestParameters);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        String requestJson = null;
        if (requestBody != null) {
            requestHeaders.add(new RequestHeader(CONTENT_TYPE_HEADER, CONTENT_TYPE_JSON));
            requestJson = this.marshaller.marshal(requestBody);
        }
        this.addGenericHeaders("PUT", uri, requestHeaders, context);
        return (O)this.connection.put(uri, requestHeaders, requestJson, (statusCode, bodyStream, headers) -> this.processResponse(statusCode, bodyStream, (List<ResponseHeader>)headers, responseType, relativePath, context));
    }

    private <O> O put(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, MultipartFormDataObject multipart, Class<O> responseType, CallContext context) {
        URI uri = this.toAbsoluteURI(relativePath, requestParameters);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        requestHeaders.add(new RequestHeader(CONTENT_TYPE_HEADER, multipart.getContentType()));
        this.addGenericHeaders("PUT", uri, requestHeaders, context);
        return (O)this.connection.put(uri, requestHeaders, multipart, (statusCode, bodyStream, headers) -> this.processResponse(statusCode, bodyStream, (List<ResponseHeader>)headers, responseType, relativePath, context));
    }

    public void put(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, Object requestBody, BodyHandler bodyHandler, CallContext context) {
        if (requestBody instanceof MultipartFormDataObject) {
            this.put(relativePath, requestHeaders, requestParameters, (MultipartFormDataObject)requestBody, bodyHandler, context);
            return;
        }
        if (requestBody instanceof MultipartFormDataRequest) {
            MultipartFormDataObject multipart = ((MultipartFormDataRequest)requestBody).toMultipartFormDataObject();
            this.put(relativePath, requestHeaders, requestParameters, multipart, bodyHandler, context);
            return;
        }
        URI uri = this.toAbsoluteURI(relativePath, requestParameters);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        String requestJson = null;
        if (requestBody != null) {
            requestHeaders.add(new RequestHeader(CONTENT_TYPE_HEADER, CONTENT_TYPE_JSON));
            requestJson = this.marshaller.marshal(requestBody);
        }
        this.addGenericHeaders("PUT", uri, requestHeaders, context);
        this.connection.put(uri, requestHeaders, requestJson, (statusCode, bodyStream, headers) -> {
            this.processResponse(statusCode, bodyStream, (List<ResponseHeader>)headers, bodyHandler, relativePath, context);
            return null;
        });
    }

    private void put(String relativePath, List<RequestHeader> requestHeaders, ParamRequest requestParameters, MultipartFormDataObject multipart, BodyHandler bodyHandler, CallContext context) {
        URI uri = this.toAbsoluteURI(relativePath, requestParameters);
        if (requestHeaders == null) {
            requestHeaders = new ArrayList<RequestHeader>();
        }
        requestHeaders.add(new RequestHeader(CONTENT_TYPE_HEADER, multipart.getContentType()));
        this.addGenericHeaders("PUT", uri, requestHeaders, context);
        this.connection.put(uri, requestHeaders, multipart, (statusCode, bodyStream, headers) -> {
            this.processResponse(statusCode, bodyStream, (List<ResponseHeader>)headers, bodyHandler, relativePath, context);
            return null;
        });
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    private URI toAbsoluteURI(String relativePath, ParamRequest requestParameters) {
        List<RequestParam> requestParameterList = requestParameters == null ? null : requestParameters.toRequestParameters();
        return this.toAbsoluteURI(relativePath, requestParameterList);
    }

    protected URI toAbsoluteURI(String relativePath, List<RequestParam> requestParameters) {
        String absolutePath = relativePath.startsWith("/") ? relativePath : "/" + relativePath;
        URIBuilder uriBuilder = new URIBuilder().setScheme(this.apiEndpoint.getScheme()).setHost(this.apiEndpoint.getHost()).setPort(this.apiEndpoint.getPort()).setPath(absolutePath);
        if (requestParameters != null) {
            for (RequestParam nvp : requestParameters) {
                uriBuilder.addParameter(nvp.getName(), nvp.getValue());
            }
        }
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to construct URI", e);
        }
    }

    protected void addGenericHeaders(String httpMethod, URI uri, List<RequestHeader> requestHeaders, CallContext context) {
        requestHeaders.addAll(this.metadataProvider.getServerMetadataHeaders());
        requestHeaders.add(new RequestHeader("Date", Communicator.getHeaderDateString()));
        if (context != null && context.getIdempotenceKey() != null) {
            requestHeaders.add(new RequestHeader("X-GCS-Idempotence-Key", context.getIdempotenceKey()));
        }
        String authorization = this.authenticator.getAuthorization(httpMethod, uri, requestHeaders);
        requestHeaders.add(new RequestHeader("Authorization", authorization));
    }

    protected static String getHeaderDateString() {
        return ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME);
    }

    protected <O> O processResponse(int statusCode, InputStream bodyStream, List<ResponseHeader> headers, Class<O> responseType, String requestPath, CallContext context) {
        if (context != null) {
            Communicator.updateContext(headers, context);
        }
        Communicator.throwExceptionIfNecessary(statusCode, bodyStream, headers, requestPath);
        return this.marshaller.unmarshal(bodyStream, responseType);
    }

    protected void processResponse(int statusCode, InputStream bodyStream, List<ResponseHeader> headers, BodyHandler bodyHandler, String requestPath, CallContext context) {
        if (context != null) {
            Communicator.updateContext(headers, context);
        }
        Communicator.throwExceptionIfNecessary(statusCode, bodyStream, headers, requestPath);
        try {
            bodyHandler.handleBody(bodyStream, headers);
        }
        catch (IOException e) {
            throw new BodyHandlerException(e);
        }
    }

    protected static void updateContext(List<ResponseHeader> headers, CallContext context) {
        String idempotenceRequestTimestampValue = ResponseHeader.getHeaderValue(headers, "X-GCS-Idempotence-Request-Timestamp");
        if (idempotenceRequestTimestampValue != null) {
            Long idempotenceRequestTimestamp = Long.valueOf(idempotenceRequestTimestampValue);
            context.setIdempotenceRequestTimestamp(idempotenceRequestTimestamp);
        } else {
            context.setIdempotenceRequestTimestamp(null);
        }
    }

    protected static void throwExceptionIfNecessary(int statusCode, InputStream bodyStream, List<ResponseHeader> headers, String requestPath) {
        if (statusCode < 200 || statusCode >= 300) {
            String body = Communicator.toString(bodyStream);
            if (body != null && !body.isEmpty() && !Communicator.isJson(headers)) {
                ResponseException cause = new ResponseException(statusCode, body, headers);
                if (statusCode == 404) {
                    throw new NotFoundException("The requested resource was not found; invalid path: " + requestPath, cause);
                }
                throw new CommunicationException(cause);
            }
            throw new ResponseException(statusCode, body, headers);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String toString(InputStream bodyStream) {
        try (InputStreamReader reader = new InputStreamReader(bodyStream, CHARSET);){
            int len;
            StringBuilder body = new StringBuilder();
            char[] buffer = new char[4096];
            while ((len = reader.read(buffer)) != -1) {
                body.append(buffer, 0, len);
            }
            String string = body.toString();
            return string;
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    private static boolean isJson(List<ResponseHeader> headers) {
        String contentType = ResponseHeader.getHeaderValue(headers, CONTENT_TYPE_HEADER);
        return contentType == null || CONTENT_TYPE_JSON.equalsIgnoreCase(contentType) || contentType.toLowerCase().startsWith(CONTENT_TYPE_JSON);
    }

    public void closeIdleConnections(long idleTime, TimeUnit timeUnit) {
        if (this.connection instanceof PooledConnection) {
            ((PooledConnection)this.connection).closeIdleConnections(idleTime, timeUnit);
        }
    }

    public void closeExpiredConnections() {
        if (this.connection instanceof PooledConnection) {
            ((PooledConnection)this.connection).closeExpiredConnections();
        }
    }

    @Override
    public void setBodyObfuscator(BodyObfuscator bodyObfuscator) {
        this.connection.setBodyObfuscator(bodyObfuscator);
    }

    @Override
    public void setHeaderObfuscator(HeaderObfuscator headerObfuscator) {
        this.connection.setHeaderObfuscator(headerObfuscator);
    }

    @Override
    public void enableLogging(CommunicatorLogger communicatorLogger) {
        this.connection.enableLogging(communicatorLogger);
    }

    @Override
    public void disableLogging() {
        this.connection.disableLogging();
    }
}

