/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java;

import com.worldline.connect.sdk.java.Client;
import com.worldline.connect.sdk.java.Communicator;
import com.worldline.connect.sdk.java.CommunicatorBuilder;
import com.worldline.connect.sdk.java.CommunicatorConfiguration;
import com.worldline.connect.sdk.java.authentication.Authenticator;
import com.worldline.connect.sdk.java.authentication.AuthorizationType;
import com.worldline.connect.sdk.java.authentication.V1HMACAuthenticator;
import com.worldline.connect.sdk.java.communication.Connection;
import com.worldline.connect.sdk.java.communication.DefaultConnectionBuilder;
import com.worldline.connect.sdk.java.communication.MetadataProvider;
import com.worldline.connect.sdk.java.communication.MetadataProviderBuilder;
import com.worldline.connect.sdk.java.json.DefaultMarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;

public final class Factory {
    private Factory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CommunicatorConfiguration createConfiguration(URI configurationFileUri, String authorizationId, String authorizationSecret) {
        Properties properties = new Properties();
        try (InputStream configurationFileInputStream = configurationFileUri.toURL().openStream();){
            properties.load(configurationFileInputStream);
            CommunicatorConfiguration communicatorConfiguration = new CommunicatorConfiguration(properties).withAuthorizationId(authorizationId).withAuthorizationSecret(authorizationSecret);
            return communicatorConfiguration;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load properties", e);
        }
    }

    public static CommunicatorBuilder createCommunicatorBuilder(URI configurationFileUri, String authorizationId, String authorizationSecret) {
        CommunicatorConfiguration configuration = Factory.createConfiguration(configurationFileUri, authorizationId, authorizationSecret);
        return Factory.createCommunicatorBuilder(configuration);
    }

    public static CommunicatorBuilder createCommunicatorBuilder(CommunicatorConfiguration configuration) {
        MetadataProvider metadataProvider = new MetadataProviderBuilder(configuration.getIntegrator()).withShoppingCartExtension(configuration.getShoppingCartExtension()).build();
        return new CommunicatorBuilder().withAPIEndpoint(configuration.getApiEndpoint()).withConnection(new DefaultConnectionBuilder(configuration.getConnectTimeout(), configuration.getSocketTimeout()).withMaxConnections(configuration.getMaxConnections()).withConnectionReuse(configuration.isConnectionReuse()).withProxyConfiguration(configuration.getProxyConfiguration()).withHttpsProtocols(configuration.getHttpsProtocols()).build()).withMetadataProvider(metadataProvider).withAuthenticator(Factory.getAuthenticator(configuration)).withMarshaller(DefaultMarshaller.INSTANCE);
    }

    private static Authenticator getAuthenticator(CommunicatorConfiguration configuration) {
        if (configuration.getAuthorizationType() == AuthorizationType.V1HMAC) {
            return new V1HMACAuthenticator(configuration.getApiKeyId(), configuration.getSecretApiKey());
        }
        throw new IllegalStateException("Unknown authorizationType " + (Object)((Object)configuration.getAuthorizationType()));
    }

    public static Communicator createCommunicator(URI configurationFileUri, String authorizationId, String authorizationSecret) {
        CommunicatorConfiguration configuration = Factory.createConfiguration(configurationFileUri, authorizationId, authorizationSecret);
        return Factory.createCommunicator(configuration);
    }

    public static Communicator createCommunicator(CommunicatorConfiguration configuration) {
        CommunicatorBuilder communicatorBuilder = Factory.createCommunicatorBuilder(configuration);
        return communicatorBuilder.build();
    }

    public static Communicator createCommunicator(URI apiEndpoint, Connection connection, Authenticator authenticator, MetadataProvider metadataProvider) {
        return new Communicator(apiEndpoint, connection, authenticator, metadataProvider, DefaultMarshaller.INSTANCE);
    }

    public static Client createClient(URI configurationFileUri, String authorizationId, String authorizationSecret) {
        Communicator communicator = Factory.createCommunicator(configurationFileUri, authorizationId, authorizationSecret);
        return Factory.createClient(communicator);
    }

    public static Client createClient(CommunicatorConfiguration configuration) {
        Communicator communicator = Factory.createCommunicator(configuration);
        return Factory.createClient(communicator);
    }

    public static Client createClient(URI apiEndpoint, Connection connection, Authenticator authenticator, MetadataProvider metadataProvider) {
        Communicator communicator = Factory.createCommunicator(apiEndpoint, connection, authenticator, metadataProvider);
        return Factory.createClient(communicator);
    }

    public static Client createClient(Communicator communicator) {
        return new Client(communicator);
    }
}

