/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.authentication;

import com.worldline.connect.sdk.java.authentication.Authenticator;
import com.worldline.connect.sdk.java.communication.RequestHeader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class V1HMACAuthenticator
implements Authenticator {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final Pattern CANONICALIZE_HEADER_REGEXP = Pattern.compile("\r?\n[\\s&&[^\r\n]]*");
    private static final Comparator<RequestHeader> REQUEST_HEADER_COMPARATOR = (header1, header2) -> header1.getName().compareTo(header2.getName());
    private final String apiKeyId;
    private final String secretApiKey;

    public V1HMACAuthenticator(String apiKeyId, String secretApiKey) {
        if (secretApiKey == null || secretApiKey.trim().isEmpty()) {
            throw new IllegalArgumentException("secretApiKey is required");
        }
        if (apiKeyId == null || apiKeyId.trim().isEmpty()) {
            throw new IllegalArgumentException("apiKeyId is required");
        }
        this.apiKeyId = apiKeyId;
        this.secretApiKey = secretApiKey;
    }

    @Override
    public String getAuthorization(String httpMethod, URI resourceUri, List<RequestHeader> httpHeaders) {
        if (httpMethod == null || httpMethod.trim().isEmpty()) {
            throw new IllegalArgumentException("httpMethod is required");
        }
        if (resourceUri == null) {
            throw new IllegalArgumentException("resourceUri is required");
        }
        String dataToSign = this.toDataToSign(httpMethod, resourceUri, httpHeaders);
        return "GCS v1HMAC:" + this.apiKeyId + ":" + this.createAuthenticationSignature(dataToSign);
    }

    String toDataToSign(String httpMethod, URI resourceUri, List<RequestHeader> httpHeaders) {
        String contentType = null;
        String date = null;
        String canonicalizedResource = V1HMACAuthenticator.toCanonicalizedResource(resourceUri);
        ArrayList<RequestHeader> xgcsHttpHeaders = new ArrayList<RequestHeader>();
        if (httpHeaders != null) {
            for (RequestHeader httpHeader : httpHeaders) {
                if ("Content-Type".equalsIgnoreCase(httpHeader.getName())) {
                    contentType = httpHeader.getValue();
                    continue;
                }
                if ("Date".equalsIgnoreCase(httpHeader.getName())) {
                    date = httpHeader.getValue();
                    continue;
                }
                String name = V1HMACAuthenticator.toCanonicalizeHeaderName(httpHeader.getName());
                if (!name.startsWith("x-gcs")) continue;
                String value = V1HMACAuthenticator.toCanonicalizeHeaderValue(httpHeader.getValue());
                RequestHeader xgcsHttpHeader = new RequestHeader(name, value);
                xgcsHttpHeaders.add(xgcsHttpHeader);
            }
        }
        Collections.sort(xgcsHttpHeaders, REQUEST_HEADER_COMPARATOR);
        StringBuilder sb = new StringBuilder(100);
        sb.append(httpMethod.toUpperCase()).append('\n');
        if (contentType != null) {
            sb.append(contentType).append('\n');
        } else {
            sb.append('\n');
        }
        sb.append(date).append('\n');
        for (RequestHeader xgcsHttpHeader : xgcsHttpHeaders) {
            sb.append(xgcsHttpHeader.getName()).append(':').append(xgcsHttpHeader.getValue()).append('\n');
        }
        sb.append(canonicalizedResource).append('\n');
        return sb.toString();
    }

    private static String toCanonicalizedResource(URI resourceUri) {
        String rawPath = resourceUri.getRawPath();
        if (resourceUri.getQuery() == null) {
            return rawPath;
        }
        return rawPath + '?' + resourceUri.getQuery();
    }

    private static String toCanonicalizeHeaderName(String originalName) {
        return originalName.toLowerCase(Locale.ENGLISH);
    }

    static String toCanonicalizeHeaderValue(String originalValue) {
        if (originalValue == null) {
            return "";
        }
        return CANONICALIZE_HEADER_REGEXP.matcher(originalValue).replaceAll(" ").trim();
    }

    String createAuthenticationSignature(String dataToSign) {
        try {
            Mac sha256Hmac = Mac.getInstance(HMAC_ALGORITHM);
            SecretKeySpec secretKey = new SecretKeySpec(this.secretApiKey.getBytes(CHARSET), HMAC_ALGORITHM);
            sha256Hmac.init(secretKey);
            byte[] unencodedResult = sha256Hmac.doFinal(dataToSign.getBytes(CHARSET));
            return Base64.getEncoder().encodeToString(unencodedResult);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No such HMAC algorithm HmacSHA256", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("Invalid HMAC key", e);
        }
    }
}

