/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.communication;

import com.worldline.connect.sdk.java.CommunicatorConfiguration;
import com.worldline.connect.sdk.java.ProxyConfiguration;
import com.worldline.connect.sdk.java.communication.CommunicationException;
import com.worldline.connect.sdk.java.communication.DefaultConnectionBuilder;
import com.worldline.connect.sdk.java.communication.JsonEntity;
import com.worldline.connect.sdk.java.communication.MultipartFormDataObject;
import com.worldline.connect.sdk.java.communication.PooledConnection;
import com.worldline.connect.sdk.java.communication.RequestHeader;
import com.worldline.connect.sdk.java.communication.ResponseHandler;
import com.worldline.connect.sdk.java.communication.ResponseHeader;
import com.worldline.connect.sdk.java.domain.UploadableFile;
import com.worldline.connect.sdk.java.logging.BodyObfuscator;
import com.worldline.connect.sdk.java.logging.CommunicatorLogger;
import com.worldline.connect.sdk.java.logging.HeaderObfuscator;
import com.worldline.connect.sdk.java.logging.LogMessageBuilder;
import com.worldline.connect.sdk.java.logging.RequestLogMessageBuilder;
import com.worldline.connect.sdk.java.logging.ResponseLogMessageBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.RequestLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.impl.io.EmptyInputStream;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;

public class DefaultConnection
implements PooledConnection {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String REQUEST_ID_ATTRIBUTE = DefaultConnection.class.getName() + ".requestId";
    private static final String START_TIMME_ATTRIBUTE = DefaultConnection.class.getName() + ".startTme";
    protected final CloseableHttpClient httpClient;
    private final HttpClientConnectionManager connectionManager;
    protected final RequestConfig requestConfig;
    private final AtomicReference<BodyObfuscator> bodyObfuscator = new AtomicReference<BodyObfuscator>(BodyObfuscator.defaultObfuscator());
    private final AtomicReference<HeaderObfuscator> headerObfuscator = new AtomicReference<HeaderObfuscator>(HeaderObfuscator.defaultObfuscator());
    private final AtomicReference<CommunicatorLogger> communicatorLogger = new AtomicReference();

    public DefaultConnection(int connectTimeout, int socketTimeout) {
        this(connectTimeout, socketTimeout, null);
    }

    public DefaultConnection(int connectTimeout, int socketTimeout, int maxConnections) {
        this(connectTimeout, socketTimeout, maxConnections, null);
    }

    public DefaultConnection(int connectTimeout, int socketTimeout, ProxyConfiguration proxyConfiguration) {
        this(connectTimeout, socketTimeout, 10, proxyConfiguration);
    }

    public DefaultConnection(int connectTimeout, int socketTimeout, int maxConnections, ProxyConfiguration proxyConfiguration) {
        this(connectTimeout, socketTimeout, maxConnections, proxyConfiguration, CommunicatorConfiguration.DEFAULT_HTTPS_PROTOCOLS);
    }

    public DefaultConnection(int connectTimeout, int socketTimeout, int maxConnections, ProxyConfiguration proxyConfiguration, Set<String> httpsProtocols) {
        this(connectTimeout, socketTimeout, maxConnections, proxyConfiguration, DefaultConnection.createSSLConnectionSocketFactory(httpsProtocols));
    }

    public DefaultConnection(int connectTimeout, int socketTimeout, int maxConnections, ProxyConfiguration proxyConfiguration, SSLConnectionSocketFactory sslConnectionSocketFactory) {
        this(connectTimeout, socketTimeout, maxConnections, true, proxyConfiguration, sslConnectionSocketFactory);
    }

    protected DefaultConnection(DefaultConnectionBuilder builder) {
        this(builder.connectTimeout, builder.socketTimeout, builder.maxConnections, builder.connectionReuse, builder.proxyConfiguration, builder.sslConnectionSocketFactory);
    }

    private DefaultConnection(int connectTimeout, int socketTimeout, int maxConnections, boolean connectionReuse, ProxyConfiguration proxyConfiguration, SSLConnectionSocketFactory sslConnectionSocketFactory) {
        if (sslConnectionSocketFactory == null) {
            throw new IllegalArgumentException("sslConnectionSocketFactory is required");
        }
        this.requestConfig = DefaultConnection.createRequestConfig(connectTimeout, socketTimeout);
        this.connectionManager = DefaultConnection.createHttpClientConnectionManager(maxConnections, sslConnectionSocketFactory);
        this.httpClient = this.createHttpClient(proxyConfiguration, connectionReuse);
    }

    static SSLConnectionSocketFactory createSSLConnectionSocketFactory(Set<String> httpsProtocols) {
        SSLContext sslContext = SSLContexts.createDefault();
        HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        Set<String> supportedProtocols = httpsProtocols != null && !httpsProtocols.isEmpty() ? httpsProtocols : CommunicatorConfiguration.DEFAULT_HTTPS_PROTOCOLS;
        return new SSLConnectionSocketFactory(sslContext, supportedProtocols.toArray(new String[0]), null, hostnameVerifier);
    }

    private static RequestConfig createRequestConfig(int connectTimeout, int socketTimeout) {
        return RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectTimeout).build();
    }

    private static HttpClientConnectionManager createHttpClientConnectionManager(int maxConnections, SSLConnectionSocketFactory sslConnectionSocketFactory) {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setDefaultMaxPerRoute(maxConnections);
        connectionManager.setMaxTotal(maxConnections + 20);
        return connectionManager;
    }

    private CloseableHttpClient createHttpClient(ProxyConfiguration proxyConfiguration, boolean connectionReuse) {
        SystemDefaultCredentialsProvider credentialsProvider;
        SystemDefaultRoutePlanner routePlanner;
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager(this.connectionManager);
        if (proxyConfiguration != null) {
            HttpHost proxy = new HttpHost(proxyConfiguration.getHost(), proxyConfiguration.getPort(), proxyConfiguration.getScheme());
            routePlanner = new DefaultProxyRoutePlanner(proxy, (SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
            credentialsProvider = new BasicCredentialsProvider();
            if (proxyConfiguration.getUsername() != null) {
                AuthScope authscope = new AuthScope(proxyConfiguration.getHost(), proxyConfiguration.getPort());
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyConfiguration.getUsername(), proxyConfiguration.getPassword());
                credentialsProvider.setCredentials(authscope, (Credentials)credentials);
                HttpRequestInterceptor proxyAuthenticationInterceptor = (arg_0, arg_1) -> DefaultConnection.lambda$createHttpClient$0((Credentials)credentials, arg_0, arg_1);
                builder = builder.addInterceptorLast(proxyAuthenticationInterceptor);
            }
        } else {
            routePlanner = new SystemDefaultRoutePlanner((SchemePortResolver)DefaultSchemePortResolver.INSTANCE, ProxySelector.getDefault());
            credentialsProvider = new SystemDefaultCredentialsProvider();
        }
        LoggingInterceptor loggingInterceptor = new LoggingInterceptor();
        builder = builder.addInterceptorLast((HttpRequestInterceptor)loggingInterceptor);
        builder = builder.addInterceptorFirst((HttpResponseInterceptor)loggingInterceptor);
        if (!connectionReuse) {
            builder = builder.setConnectionReuseStrategy((ConnectionReuseStrategy)NoConnectionReuseStrategy.INSTANCE);
        }
        return builder.setRoutePlanner((HttpRoutePlanner)routePlanner).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    @Override
    public <R> R get(URI uri, List<RequestHeader> requestHeaders, ResponseHandler<R> responseHandler) {
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setConfig(this.requestConfig);
        this.addHeaders((HttpRequestBase)httpGet, requestHeaders);
        return this.executeRequest((HttpUriRequest)httpGet, responseHandler);
    }

    @Override
    public <R> R delete(URI uri, List<RequestHeader> requestHeaders, ResponseHandler<R> responseHandler) {
        HttpDelete httpDelete = new HttpDelete(uri);
        httpDelete.setConfig(this.requestConfig);
        this.addHeaders((HttpRequestBase)httpDelete, requestHeaders);
        return this.executeRequest((HttpUriRequest)httpDelete, responseHandler);
    }

    @Override
    public <R> R post(URI uri, List<RequestHeader> requestHeaders, String body, ResponseHandler<R> responseHandler) {
        HttpEntity requestEntity = DefaultConnection.createRequestEntity(body);
        return this.post(uri, requestHeaders, requestEntity, responseHandler);
    }

    @Override
    public <R> R post(URI uri, List<RequestHeader> requestHeaders, MultipartFormDataObject multipart, ResponseHandler<R> responseHandler) {
        HttpEntity requestEntity = DefaultConnection.createRequestEntity(multipart);
        return this.post(uri, requestHeaders, requestEntity, responseHandler);
    }

    private <R> R post(URI uri, List<RequestHeader> requestHeaders, HttpEntity requestEntity, ResponseHandler<R> responseHandler) {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setConfig(this.requestConfig);
        this.addHeaders((HttpRequestBase)httpPost, requestHeaders);
        if (requestEntity != null) {
            httpPost.setEntity(requestEntity);
        }
        return this.executeRequest((HttpUriRequest)httpPost, responseHandler);
    }

    @Override
    public <R> R put(URI uri, List<RequestHeader> requestHeaders, String body, ResponseHandler<R> responseHandler) {
        HttpEntity requestEntity = DefaultConnection.createRequestEntity(body);
        return this.put(uri, requestHeaders, requestEntity, responseHandler);
    }

    @Override
    public <R> R put(URI uri, List<RequestHeader> requestHeaders, MultipartFormDataObject multipart, ResponseHandler<R> responseHandler) {
        HttpEntity requestEntity = DefaultConnection.createRequestEntity(multipart);
        return this.put(uri, requestHeaders, requestEntity, responseHandler);
    }

    private <R> R put(URI uri, List<RequestHeader> requestHeaders, HttpEntity requestEntity, ResponseHandler<R> responseHandler) {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setConfig(this.requestConfig);
        this.addHeaders((HttpRequestBase)httpPut, requestHeaders);
        if (requestEntity != null) {
            httpPut.setEntity(requestEntity);
        }
        return this.executeRequest((HttpUriRequest)httpPut, responseHandler);
    }

    private static HttpEntity createRequestEntity(String body) {
        return body != null ? new JsonEntity(body, CHARSET) : null;
    }

    private static HttpEntity createRequestEntity(MultipartFormDataObject multipart) {
        return new MultipartFormDataEntity(multipart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <R> R executeRequest(HttpUriRequest request, ResponseHandler<R> responseHandler) {
        String requestId = UUID.randomUUID().toString();
        long startTime = System.currentTimeMillis();
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute(REQUEST_ID_ATTRIBUTE, (Object)requestId);
        context.setAttribute(START_TIMME_ATTRIBUTE, (Object)startTime);
        boolean logRuntimeExceptions = true;
        try {
            CloseableHttpResponse httpResponse = this.httpClient.execute(request, (HttpContext)context);
            HttpEntity entity = httpResponse.getEntity();
            try (Object bodyStream = EmptyInputStream.INSTANCE;){
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                List<ResponseHeader> headers = this.getHeaders((HttpResponse)httpResponse);
                InputStream inputStream = bodyStream = entity == null ? null : entity.getContent();
                if (bodyStream == null) {
                    bodyStream = EmptyInputStream.INSTANCE;
                }
                logRuntimeExceptions = false;
                R r = responseHandler.handleResponse(statusCode, (InputStream)bodyStream, headers);
                return r;
            }
        }
        catch (IOException e) {
            DefaultConnection.logError(requestId, e, startTime, this.communicatorLogger.get());
            throw new CommunicationException(e);
        }
        catch (CommunicationException e) {
            DefaultConnection.logError(requestId, e, startTime, this.communicatorLogger.get());
            throw e;
        }
        catch (RuntimeException e) {
            if (!logRuntimeExceptions) throw e;
            DefaultConnection.logError(requestId, e, startTime, this.communicatorLogger.get());
            throw e;
        }
    }

    protected void addHeaders(HttpRequestBase httpRequestBase, List<RequestHeader> requestHeaders) {
        if (requestHeaders != null) {
            for (RequestHeader requestHeader : requestHeaders) {
                httpRequestBase.addHeader((Header)new BasicHeader(requestHeader.getName(), requestHeader.getValue()));
            }
        }
    }

    protected List<ResponseHeader> getHeaders(HttpResponse httpResponse) {
        Header[] headers = httpResponse.getAllHeaders();
        ArrayList<ResponseHeader> result = new ArrayList<ResponseHeader>(headers.length);
        for (Header header : headers) {
            result.add(new ResponseHeader(header.getName(), header.getValue()));
        }
        return result;
    }

    @Override
    public void closeIdleConnections(long idleTime, TimeUnit timeUnit) {
        this.connectionManager.closeIdleConnections(idleTime, timeUnit);
    }

    @Override
    public void closeExpiredConnections() {
        this.connectionManager.closeExpiredConnections();
    }

    @Override
    public void setBodyObfuscator(BodyObfuscator bodyObfuscator) {
        if (bodyObfuscator == null) {
            throw new IllegalArgumentException("bodyObfuscator is required");
        }
        this.bodyObfuscator.set(bodyObfuscator);
    }

    @Override
    public void setHeaderObfuscator(HeaderObfuscator headerObfuscator) {
        if (headerObfuscator == null) {
            throw new IllegalArgumentException("headerObfuscator is required");
        }
        this.headerObfuscator.set(headerObfuscator);
    }

    @Override
    public void enableLogging(CommunicatorLogger communicatorLogger) {
        if (communicatorLogger == null) {
            throw new IllegalArgumentException("communicatorLogger is required");
        }
        this.communicatorLogger.set(communicatorLogger);
    }

    @Override
    public void disableLogging() {
        this.communicatorLogger.set(null);
    }

    private void logRequest(HttpRequest request, String requestId, CommunicatorLogger logger) {
        try {
            RequestLine requestLine = request.getRequestLine();
            String method = requestLine.getMethod();
            String uri = requestLine.getUri();
            RequestLogMessageBuilder logMessageBuilder = new RequestLogMessageBuilder(requestId, method, uri, this.bodyObfuscator.get(), this.headerObfuscator.get());
            DefaultConnection.addHeaders(logMessageBuilder, request.getAllHeaders());
            if (request instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)request;
                HttpEntity entity = entityEnclosingRequest.getEntity();
                String contentType = DefaultConnection.getContentType(entity, () -> request.getFirstHeader("Content-Type"));
                boolean isBinaryContent = DefaultConnection.isBinaryContent(contentType);
                if (entity != null && !entity.isRepeatable() && !isBinaryContent) {
                    entity = new BufferedHttpEntity(entity);
                    entityEnclosingRequest.setEntity(entity);
                }
                DefaultConnection.setBody(logMessageBuilder, entity, contentType, isBinaryContent);
            }
            logger.log(logMessageBuilder.getMessage());
        }
        catch (Exception e) {
            logger.log(String.format("An error occurred trying to log request '%s'", requestId), e);
        }
    }

    private void logResponse(HttpResponse response, String requestId, long startTime, CommunicatorLogger logger) {
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            ResponseLogMessageBuilder logMessageBuilder = new ResponseLogMessageBuilder(requestId, statusCode, duration, this.bodyObfuscator.get(), this.headerObfuscator.get());
            DefaultConnection.addHeaders(logMessageBuilder, response.getAllHeaders());
            HttpEntity entity = response.getEntity();
            String contentType = DefaultConnection.getContentType(entity, () -> response.getFirstHeader("Content-Type"));
            boolean isBinaryContent = DefaultConnection.isBinaryContent(contentType);
            if (entity != null && !entity.isRepeatable() && !isBinaryContent) {
                entity = new BufferedHttpEntity(entity);
                response.setEntity(entity);
            }
            DefaultConnection.setBody(logMessageBuilder, entity, contentType, isBinaryContent);
            logger.log(logMessageBuilder.getMessage());
        }
        catch (Exception e) {
            logger.log(String.format("An error occurred trying to log response '%s'", requestId), e);
        }
    }

    private static void addHeaders(LogMessageBuilder logMessageBuilder, Header[] headers) {
        if (headers != null) {
            for (Header header : headers) {
                logMessageBuilder.addHeader(header.getName(), header.getValue());
            }
        }
    }

    private static String getContentType(HttpEntity entity, Supplier<Header> defaultHeaderSupplier) {
        Header contentTypeHeader;
        Header header = contentTypeHeader = entity != null ? entity.getContentType() : null;
        if (contentTypeHeader == null) {
            contentTypeHeader = defaultHeaderSupplier.get();
        }
        return contentTypeHeader != null ? contentTypeHeader.getValue() : null;
    }

    private static void setBody(LogMessageBuilder logMessageBuilder, HttpEntity entity, String contentType, boolean isBinaryContent) throws IOException {
        if (entity == null) {
            logMessageBuilder.setBody("", contentType);
        } else if (entity instanceof JsonEntity) {
            String body = ((JsonEntity)entity).getString();
            logMessageBuilder.setBody(body, contentType);
        } else if (isBinaryContent) {
            logMessageBuilder.setBinaryContentBody(contentType);
        } else {
            InputStream body = entity.getContent();
            logMessageBuilder.setBody(body, CHARSET, contentType);
        }
    }

    private static boolean isBinaryContent(String contentType) {
        return contentType != null && !contentType.startsWith("text/") && !contentType.contains("json") && !contentType.contains("xml");
    }

    private static void logError(String requestId, Exception error, long startTime, CommunicatorLogger logger) {
        if (logger != null) {
            String messageTemplate = "Error occurred for outgoing request (requestId='%s', %d ms)";
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            String message = String.format("Error occurred for outgoing request (requestId='%s', %d ms)", requestId, duration);
            logger.log(message, error);
        }
    }

    private static /* synthetic */ void lambda$createHttpClient$0(Credentials credentials, HttpRequest request, HttpContext context) throws HttpException, IOException {
        Header header = request.getFirstHeader("Proxy-Authorization");
        if (header == null) {
            header = new BasicScheme((Charset)null).authenticate(credentials, request, context);
            if (!"Proxy-Authorization".equals(header.getName())) {
                header = new BasicHeader("Proxy-Authorization", header.getValue());
            }
            request.setHeader(header);
        }
    }

    static /* synthetic */ Charset access$700() {
        return CHARSET;
    }

    private static final class UploadableFileBody
    implements ContentBody {
        private final ContentBody delegate;
        private final long contentLength;

        private UploadableFileBody(UploadableFile file) {
            InputStream content = file.getContent();
            this.delegate = new InputStreamBody(content, ContentType.create((String)file.getContentType()), file.getFileName());
            this.contentLength = Math.max(file.getContentLength(), -1L);
        }

        public String getMimeType() {
            return this.delegate.getMimeType();
        }

        public String getMediaType() {
            return this.delegate.getMediaType();
        }

        public String getSubType() {
            return this.delegate.getSubType();
        }

        public String getCharset() {
            return this.delegate.getCharset();
        }

        public String getTransferEncoding() {
            return this.delegate.getTransferEncoding();
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public String getFilename() {
            return this.delegate.getFilename();
        }

        public void writeTo(OutputStream out) throws IOException {
            this.delegate.writeTo(out);
        }
    }

    private static final class MultipartFormDataEntity
    implements HttpEntity {
        private static final ContentType TEXT_PLAIN_UTF8 = ContentType.create((String)"text/plain", (Charset)DefaultConnection.access$700());
        private final HttpEntity delegate;
        private final boolean isChunked;

        private MultipartFormDataEntity(MultipartFormDataObject multipart) {
            boolean hasNegativeContentLength = false;
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setBoundary(multipart.getBoundary()).setMode(HttpMultipartMode.RFC6532);
            for (Map.Entry<String, String> entry : multipart.getValues().entrySet()) {
                builder = builder.addTextBody(entry.getKey(), entry.getValue(), TEXT_PLAIN_UTF8);
            }
            for (Map.Entry<String, Object> entry : multipart.getFiles().entrySet()) {
                builder = builder.addPart(entry.getKey(), (ContentBody)new UploadableFileBody((UploadableFile)entry.getValue()));
                hasNegativeContentLength |= ((UploadableFile)entry.getValue()).getContentLength() < 0L;
            }
            this.delegate = builder.build();
            this.isChunked = hasNegativeContentLength;
            Header contentType = this.delegate.getContentType();
            if (contentType == null || !multipart.getContentType().equals(contentType.getValue())) {
                throw new IllegalStateException("MultipartEntityBuilder did not create the expected content type");
            }
        }

        public boolean isRepeatable() {
            return false;
        }

        public boolean isChunked() {
            return this.isChunked;
        }

        public long getContentLength() {
            return this.delegate.getContentLength();
        }

        public Header getContentType() {
            return this.delegate.getContentType();
        }

        public Header getContentEncoding() {
            return this.delegate.getContentEncoding();
        }

        public InputStream getContent() throws IOException {
            return this.delegate.getContent();
        }

        public void writeTo(OutputStream outstream) throws IOException {
            this.delegate.writeTo(outstream);
        }

        public boolean isStreaming() {
            return true;
        }

        @Deprecated
        public void consumeContent() throws IOException {
            this.delegate.consumeContent();
        }
    }

    private final class LoggingInterceptor
    implements HttpRequestInterceptor,
    HttpResponseInterceptor {
        private LoggingInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            String requestId;
            CommunicatorLogger logger = (CommunicatorLogger)DefaultConnection.this.communicatorLogger.get();
            if (logger != null && (requestId = (String)context.getAttribute(REQUEST_ID_ATTRIBUTE)) != null) {
                DefaultConnection.this.logRequest(request, requestId, logger);
            }
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            CommunicatorLogger logger = (CommunicatorLogger)DefaultConnection.this.communicatorLogger.get();
            if (logger != null) {
                String requestId = (String)context.getAttribute(REQUEST_ID_ATTRIBUTE);
                Long startTime = (Long)context.getAttribute(START_TIMME_ATTRIBUTE);
                if (requestId != null && startTime != null) {
                    DefaultConnection.this.logResponse(response, requestId, startTime, logger);
                }
            }
        }
    }
}

