/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.communication;

import com.worldline.connect.sdk.java.CommunicatorConfiguration;
import com.worldline.connect.sdk.java.ProxyConfiguration;
import com.worldline.connect.sdk.java.communication.DefaultConnection;
import java.util.Set;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public class DefaultConnectionBuilder {
    final int connectTimeout;
    final int socketTimeout;
    int maxConnections;
    boolean connectionReuse;
    ProxyConfiguration proxyConfiguration;
    SSLConnectionSocketFactory sslConnectionSocketFactory;

    public DefaultConnectionBuilder(int connectTimeout, int socketTimeout) {
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.maxConnections = 10;
        this.sslConnectionSocketFactory = DefaultConnection.createSSLConnectionSocketFactory(CommunicatorConfiguration.DEFAULT_HTTPS_PROTOCOLS);
        this.connectionReuse = true;
    }

    public DefaultConnectionBuilder withMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public DefaultConnectionBuilder withConnectionReuse(boolean connectionReuse) {
        this.connectionReuse = connectionReuse;
        return this;
    }

    public DefaultConnectionBuilder withProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        return this;
    }

    public DefaultConnectionBuilder withHttpsProtocols(Set<String> httpsProtocols) {
        return this.withSslConnectionSocketFactory(DefaultConnection.createSSLConnectionSocketFactory(httpsProtocols));
    }

    public DefaultConnectionBuilder withSslConnectionSocketFactory(SSLConnectionSocketFactory sslConnectionSocketFactory) {
        this.sslConnectionSocketFactory = sslConnectionSocketFactory;
        return this;
    }

    public DefaultConnection build() {
        return new DefaultConnection(this);
    }
}

