/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.communication;

import com.worldline.connect.sdk.java.communication.MetadataProviderBuilder;
import com.worldline.connect.sdk.java.communication.RequestHeader;
import com.worldline.connect.sdk.java.domain.ShoppingCartExtension;
import com.worldline.connect.sdk.java.json.DefaultMarshaller;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class MetadataProvider {
    private static final String SDK_VERSION = "7.4.0";
    private static final String SERVER_META_INFO_HEADER = "X-GCS-ServerMetaInfo";
    static final Set<String> PROHIBITED_HEADERS;
    private static final Charset CHARSET;
    private final Collection<RequestHeader> metadataHeaders;

    public MetadataProvider(String integrator) {
        this(integrator, null, Collections.emptyList());
    }

    protected MetadataProvider(MetadataProviderBuilder builder) {
        this(builder.integrator, builder.shoppingCartExtension, builder.additionalRequestHeaders);
    }

    private MetadataProvider(String integrator, ShoppingCartExtension shoppingCartExtension, Collection<RequestHeader> additionalRequestHeaders) {
        if (integrator == null || integrator.trim().isEmpty()) {
            throw new IllegalArgumentException("integrator is required");
        }
        MetadataProvider.validateAdditionalRequestHeaders(additionalRequestHeaders);
        ServerMetaInfo serverMetaInfo = new ServerMetaInfo();
        serverMetaInfo.platformIdentifier = this.getPlatformIdentifier();
        serverMetaInfo.sdkIdentifier = this.getSdkIdentifier();
        serverMetaInfo.sdkCreator = "Worldline";
        serverMetaInfo.integrator = integrator;
        serverMetaInfo.shoppingCartExtension = shoppingCartExtension;
        String serverMetaInfoString = DefaultMarshaller.INSTANCE.marshal(serverMetaInfo);
        RequestHeader serverMetaInfoHeader = new RequestHeader(SERVER_META_INFO_HEADER, Base64.getEncoder().encodeToString(serverMetaInfoString.getBytes(CHARSET)));
        if (additionalRequestHeaders == null || additionalRequestHeaders.isEmpty()) {
            this.metadataHeaders = Collections.singleton(serverMetaInfoHeader);
        } else {
            ArrayList<RequestHeader> requestHeaders = new ArrayList<RequestHeader>(additionalRequestHeaders.size() + 1);
            requestHeaders.add(serverMetaInfoHeader);
            requestHeaders.addAll(additionalRequestHeaders);
            this.metadataHeaders = Collections.unmodifiableList(requestHeaders);
        }
    }

    static void validateAdditionalRequestHeaders(Collection<RequestHeader> additionalRequestHeaders) {
        if (additionalRequestHeaders != null) {
            for (RequestHeader additionalRequestHeader : additionalRequestHeaders) {
                MetadataProvider.validateAdditionalRequestHeader(additionalRequestHeader);
            }
        }
    }

    static void validateAdditionalRequestHeader(RequestHeader additionalRequestHeader) {
        if (PROHIBITED_HEADERS.contains(additionalRequestHeader.getName())) {
            throw new IllegalArgumentException("request header not allowed: " + additionalRequestHeader);
        }
    }

    public final Collection<RequestHeader> getServerMetadataHeaders() {
        return this.metadataHeaders;
    }

    protected final String getPlatformIdentifier() {
        Properties properties = System.getProperties();
        StringBuilder sb = new StringBuilder();
        sb.append(properties.get("os.name"));
        sb.append("/");
        sb.append(properties.get("os.version"));
        sb.append(" ");
        sb.append("Java");
        sb.append("/");
        sb.append(properties.get("java.vm.specification.version"));
        sb.append(" ");
        sb.append("(");
        sb.append(properties.get("java.vm.vendor"));
        sb.append("; ");
        sb.append(properties.get("java.vm.name"));
        sb.append("; ");
        sb.append(properties.get("java.version"));
        sb.append(")");
        return sb.toString();
    }

    protected final String getSdkIdentifier() {
        return "JavaServerSDK/v7.4.0";
    }

    static {
        TreeSet<String> prohibitedHeaders = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        prohibitedHeaders.add(SERVER_META_INFO_HEADER);
        prohibitedHeaders.add("X-GCS-Idempotence-Key");
        prohibitedHeaders.add("Date");
        prohibitedHeaders.add("Content-Type");
        prohibitedHeaders.add("Authorization");
        PROHIBITED_HEADERS = Collections.unmodifiableSet(prohibitedHeaders);
        CHARSET = StandardCharsets.UTF_8;
    }

    static final class ServerMetaInfo {
        String platformIdentifier;
        String sdkIdentifier;
        String sdkCreator;
        String integrator;
        ShoppingCartExtension shoppingCartExtension;

        ServerMetaInfo() {
        }
    }
}

